<?php 

function custom_html($title,$content) {
	if($title) {
	echo "<h3>".$title."</h3>";
	}
	echo $content;
}

function contact_form($col,$title,$desc,$adminemail,$msg) {
	if(isset($_POST[$col.'submitted'])) { ?>

<?php 
	//Check to see if the honeypot captcha field was filled in
	if(trim($_POST[$col.'checking']) !== '') {
		$captchaError = true;
	} else {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST[$col.'name']) === '') {
			$nameError = 'You forgot to enter your name.';
			$hasError = true;
		} else {
			$name = trim($_POST[$col.'name']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST[$col.'email']) === '')  {
			$emailError = 'You forgot to enter your email address.';
			$hasError = true;
		} else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST[$col.'email']))) {
			$emailError = 'You entered an invalid email address.';
			$hasError = true;
		} else {
			$email = trim($_POST[$col.'email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST[$col.'comments']) === '') {
			$commentError = 'You forgot to enter your comments.';
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST[$col.'comments']));
			} else {
				$comments = trim($_POST[$col.'comments']);
			}
		}
			
		//If there is no error, send the email
		if(!isset($hasError)) {
			
			if($adminemail) { 
			$emailTo = $adminemail;
			} else {
			$emailTo = get_option("admin_email");
			}
			$subject = GEN_TERM_S1.$name;
			$sendCopy = trim($_POST['sendCopy']);
			$body = GEN_TERM_B.": $name \n\n".GEN_TERM_C.": $email \n\n".GEN_TERM_W.": $comments";
			$headers = 'From: '.get_option('blogname').' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			mail($emailTo, $subject, $body, $headers);

			if($sendCopy == true) {
				$subject = 'You emailed Your Name';
				$headers = 'From: Your Name <noreply@somedomain.com>';
				mail($email, $subject, $body, $headers);
			}

			$emailSent = true;

		}
	}
} 

if($title) {
	echo "<h3>".$title."</h3>";
}

 if(isset($emailSent) && $emailSent == true) { ?>

	<div class="thanks" id="thanks<?php echo $col; ?>">
		<h3><?php echo GEN_TERM_T; ?>, <?php echo $name;?></h3>
		 <p><?php if($msg) { echo $msg; } else { echo GEN_TERM_T1; } ?></p>
	</div>
    <script type="text/javascript">
		var toppanelform = jQuery('#panel .thanks').attr('id'); // if form is in top panel trigger drop panel
		if(toppanelform) {
		jQuery(document).ready(function() {
			jQuery("#toggle a").toggle();
			jQuery("div#panel").animate({height: "show"}, 900, "easeInOutCubic");
		});
		}
    </script>

<?php } else { ?>
		<form id="<?php echo $col; ?>contactform" class="contactform" method="post" action="<?php $_SERVER['PHP_SELF'] ?>">
			
            <ol class="forms">
            <?php if(isset($hasError) || isset($captchaError)) { ?>
            <li>
            	<span><img src="<?php bloginfo('template_url') ?>/images/error.png" alt="error key" /> = <?php echo GEN_TERM_E ?></span><div class="clear"></div></span>
			<?php } elseif($desc) { ?>
            <li>
            <?	echo $desc; ?>
            </li>
            <?php } ?>
			<li>
                <input <?php if($nameError != '') { ?> style="border-color: #ff0000;border-width:2px" onclick="this.style.cssText='border-color:#dfdfdf #f8f8f8 #f8f8f8 #dfdfdf'" <?php } ?> type="text" class="field" name="<?php echo $col; ?>name" id="<?php echo $col; ?>name" value="<?php if(isset($_POST[$col.'name'])) echo $_POST[$col.'name'];?>" />
                <label for="<?php echo $col; ?>name"><small><?php echo GEN_TERM_B ?> <span class="required">*</span></small></label>
			</li>
            
			<li>
                   <input <?php if($emailError != '') { ?> style="border-color: #ff0000;border-width:2px" onclick="this.style.cssText='border-color:#dfdfdf #f8f8f8 #f8f8f8 #dfdfdf'" <?php } ?> type="text" class="field" name="<?php echo $col; ?>email" id="<?php echo $col; ?>email" value="<?php if(isset($_POST[$col.'email']))  echo $_POST[$col.'email'];?>" />				                   <label for="<?php echo $col; ?>email"><small><?php echo GEN_TERM_C ?> <span class="required">*</span></small></label>
			</li>
				
			<li class="textarea">
                   <textarea <?php if($commentError != '') { ?> style="border-color: #ff0000;border-width:2px" onclick="this.style.cssText='border-color:#dfdfdf #f8f8f8 #f8f8f8 #dfdfdf'" <?php } ?> class="field" name="<?php echo $col; ?>comments" id="<?php echo $col; ?>comments" rows="20" cols="30" ><?php if(isset($_POST[$col.'comments'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST[$col.'comments']); } else { echo $_POST[$col.'comments']; } } ?></textarea>
                    <label class="screenReader" for="<?php echo $col; ?>comments">Enquiry</label>
			</li>
			<li style="left: -9999px; position: absolute; top: -9999px;"><label for="<?php echo $col; ?>checking" style="left: -9999px; position: absolute; top: -9999px;">If you want to submit this form, do not enter anything in this field</label><input type="text" name="<?php echo $col; ?>checking" id="<?php echo $col; ?>checking" style="left: -9999px; position: absolute; top: -9999px;" value="<?php if(isset($_POST['checking']))  echo $_POST['checking'];?>" /></li>
				<li class="buttons"><input type="hidden" name="<?php echo $col; ?>submitted" id="<?php echo $col; ?>submitted" value="true" />
                <div class="clear"></div>
                <button type="submit"><?php echo GEN_TERM_D ?></button></li>
                
			</ol>
            	
            
        </form>

	<?php if(isset($_POST[$col.'submitted'])) { ?>
    <script type="text/javascript">
		var toppanelform = jQuery('#panel #<?php echo $col; ?>contactform').attr('id'); // if form is in top panel trigger drop panel
		if(toppanelform) {
		jQuery(document).ready(function() {
			jQuery("#toggle a").toggle();
			jQuery("div#panel").animate({height: "show"}, 900, "easeInOutCubic");
		});
		}
    </script>
    <?php } ?>

<?php }
}

function pages_list($title,$exclude) {
	if($title) {
	echo "<h3>".$title."</h3>";
	}
	
	echo "<ul class=\"widgetlinks\">";
	$show_pages = wp_list_pages('echo=0&title_li=&exclude='.$exclude);
	$show_pages = preg_replace("@<span[^>]*?>.*?</span>@si", "", $show_pages); // Removes page descriptions
	echo $show_pages;
	echo "</ul>";
}

function recent_posts($title,$cat,$posts) {
	if($title) {
	echo "<h3>".$title."</h3>";
	} 
	
	echo "<ul class=\"widgetlinks\">";	
	global $post;
	$getposts = get_posts('category='.$cat.'&numberposts='.$posts);
	foreach($getposts as $post) :
	?>
	<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
	<?php endforeach;
	wp_reset_query();
	echo "</ul>";
}

function categories($title,$cats) {
	if($title) {
	echo "<h3>".$title."</h3>";
	} 
	
	echo "<ul class=\"widgetlinks\">";	
	if($cats) {
	foreach ($cats as $value)
	{
		$string = $string.$value.",";
    }
	wp_list_categories('include='.$string.'&title_li=');
	} else {
	wp_list_categories('title_li=');
	}
	echo "</ul>";	
}

function meta_information($title,$meta1,$meta2,$meta3,$meta4,$meta5) {
	if($title) {
	echo "<h3>".$title."</h3>";
	} 
	
	echo "<ul class=\"widgetlinks\">";	
	if($meta1) {
	wp_register();
	} ?>
    
	<?php if($meta2) { ?>
    <li><?php wp_loginout(); ?></li>
    <?php } ?>
    
    <?php if($meta3) { ?>
	<li><a href="<?php bloginfo('rss2_url'); ?>" >Entries RSS</a></li> 
    <?php } ?>
    
	<?php if($meta4) { ?>
	<li><?php  comments_rss_link('Comments RSS'); ?></li>
    <?php } ?>
    
    <?php if($meta5) { ?>
	<li><a href="http://wordpress.org/" title="Powered by WordPress, state-of-the-art semantic personal publishing platform.">WordPress</a></li>
	<?php wp_meta();
	}
	echo "</ul>";	
}


function catch_image() { // Check if image exists within post and return first one. 
  global $post, $posts;
  $first_img = '';
  $short_img = '';
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $shrtoutput = preg_match_all('/imageeffect.+url=[\'"]([^\'"]+)[\'"].*/i', $post->post_content, $shrtmatches); // Check shortcode image
  
  $short_img = $shrtmatches [1] [0];
  $first_img = $matches [1] [0];

  if($short_img) {
  return $short_img;
  } else {
  return $first_img;  
  }
}
?>
