/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright  1993 Bigelow & Holmes Inc. All rights reserved. Pat. Des. 289,420.
 * Pats. Pend.
 * 
 * Trademark:
 * Lucida is a registered trademark of Bigelow & Holmes Inc.
 * 
 * Description:
 * Characteristics:
 * Large x-height, making it readable at all sizes.
 * 
 * Uses: Wide range of uses including directories, tables, forms, memos,
 * telefaxes, manuals, heads, titles, posters, and displays.
 * 
 * Guidelines: At larger sizes (14 points or more), subtracting a few units of
 * letter spacing gives a tighter look. When using all capitals, you can use small
 * amounts of additional letter spacing. At larger sizes, space capitals more
 * tightly. Complementary fonts include Lucida Bright, Lucida Arrows, and Lucida
 * Stars. Lucida Fax at smaller sizes and lower resolutions. The ampersands,
 * interrobangs, and circled Lucida Sans numerals in Lucida Icons combine well.
 */
Cufon.registerFont({"w":227,"face":{"font-family":"Lucida Sans Unicode","font-weight":400,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 2 3 5 4 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-32 -362 351 76.2045","underline-thickness":"17.9297","underline-position":"-27.0703","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":113},"!":{"d":"40,0r0,-35r34,0r0,35r-34,0xm44,-69r-4,-191r34,0r-4,191r-26,0","w":113},"\"":{"d":"24,-191r-4,-87r34,0r-4,87r-26,0xm85,-191r-5,-87r35,0r-4,87r-26,0","w":134},"#":{"d":"36,0r19,-78r-52,0r4,-22r54,0r15,-60r-57,0r4,-22r58,0r20,-78r22,0r-19,78r46,0r19,-78r23,0r-20,78r53,0r-4,22r-54,0r-15,60r57,0r-5,22r-58,0r-19,78r-23,0r20,-78r-46,0r-20,78r-22,0xm83,-100r46,0r16,-60r-47,0"},"$":{"d":"185,-73v0,39,-26,66,-60,73r0,22r-18,0r0,-22v-21,0,-43,-5,-69,-15r0,-29v26,12,49,18,69,18r0,-93v-37,-26,-59,-34,-61,-79v-2,-36,26,-60,61,-62r0,-22r18,0r0,22v17,0,35,4,56,12r0,28v-22,-10,-41,-15,-56,-16r0,92v30,22,60,28,60,71xm125,-28v27,-8,38,-36,24,-60v-4,-5,-11,-12,-24,-21r0,81xm107,-155r0,-80v-29,8,-38,35,-25,59v4,6,13,13,25,21"},"%":{"d":"4,7r205,-274r27,0r-205,274r-27,0xm113,-195v0,37,-21,65,-56,65v-35,0,-55,-28,-55,-65v0,-37,19,-65,55,-65v36,0,56,28,56,65xm57,-243v-40,1,-39,95,0,96v39,0,42,-96,0,-96xm239,-65v0,37,-21,65,-56,65v-35,0,-55,-28,-55,-65v0,-37,20,-65,55,-65v35,0,56,28,56,65xm183,-113v-40,1,-39,95,0,96v39,0,42,-96,0,-96","w":240},"&":{"d":"122,-267v32,-1,59,22,58,53v0,26,-19,49,-57,68v17,31,38,59,61,86v13,-18,17,-45,16,-78r34,0v0,38,-11,71,-34,99v11,13,23,26,36,39r-49,0r-13,-15v-56,47,-161,15,-161,-62v0,-40,21,-68,63,-82v-35,-50,-12,-107,46,-108xm88,-138v-69,20,-40,122,24,118v16,0,32,-5,47,-16v-25,-30,-49,-64,-71,-102xm120,-241v-37,0,-30,44,-10,73v25,-11,37,-27,37,-46v1,-16,-12,-27,-27,-27","w":251},"'":{"d":"28,-182r-8,-96r43,0r-9,96r-26,0","w":82},"(":{"d":"104,-254v-64,57,-65,225,0,282r0,24v-69,-41,-109,-167,-60,-259v16,-30,35,-54,60,-71r0,24","w":117},")":{"d":"13,28v65,-57,64,-225,0,-282r0,-24v69,42,109,168,60,260v-16,30,-35,53,-60,70r0,-24","w":117},"*":{"d":"146,-227r8,25r-53,12v0,-7,-1,-11,-5,-15xm137,-147r-22,15r-27,-47v6,-1,10,-4,12,-9xm58,-132r-21,-15r36,-41v2,5,7,8,13,9xm19,-202r8,-25r50,22v-4,3,-6,10,-4,15xm74,-260r26,0r-6,54v-4,-3,-11,-2,-15,0","w":173},"+":{"d":"134,0r0,-95r-95,0r0,-18r95,0r0,-95r18,0r0,95r95,0r0,18r-95,0r0,95r-18,0","w":286},",":{"d":"35,56r0,-13v12,-2,18,-20,17,-43r-17,0r0,-43r44,0v3,50,-2,99,-44,99","w":113},"-":{"d":"26,-95r0,-22r156,0r0,22r-156,0","w":208},".":{"d":"35,0r0,-43r44,0r0,43r-44,0","w":113},"\/":{"d":"39,52r92,-312r19,0r-93,312r-18,0","w":188},"0":{"d":"114,-267v122,0,123,274,0,274v-122,0,-123,-274,0,-274xm114,-20v36,0,54,-36,54,-110v0,-74,-18,-111,-54,-111v-36,0,-54,37,-54,111v0,74,18,110,54,110"},"1":{"d":"94,0r0,-234r-41,0r0,-22r76,-6r0,262r-35,0"},"2":{"d":"36,-250v59,-33,150,-19,150,55v0,76,-107,103,-114,165r113,0r0,30r-155,0v-12,-90,119,-112,119,-194v0,-59,-70,-56,-113,-26r0,-30"},"3":{"d":"188,-72v1,74,-78,93,-151,70r0,-32v54,26,111,18,114,-38v2,-41,-36,-56,-90,-54r0,-24v51,2,84,-13,84,-51v0,-50,-67,-46,-105,-25r0,-30v57,-21,141,-15,140,50v0,31,-19,52,-55,65v42,10,63,33,63,69"},"4":{"d":"136,0r0,-74r-118,0r0,-26r118,-160r32,0r0,158r35,0r0,28r-35,0r0,74r-32,0xm52,-102r86,0r0,-116"},"5":{"d":"185,-75v1,69,-71,95,-141,76r0,-31v46,21,104,10,104,-46v0,-49,-47,-63,-100,-58r0,-126r132,0r0,30r-101,0r0,69v61,0,106,28,106,86"},"6":{"d":"24,-124v1,-81,26,-141,106,-143v16,0,35,3,58,10r0,30v-76,-32,-127,-12,-126,92v41,-61,140,-28,140,49v0,52,-37,93,-87,93v-64,0,-92,-59,-91,-131xm118,-20v32,0,49,-26,49,-60v0,-36,-18,-62,-50,-62v-28,-1,-54,23,-54,50v0,40,18,72,55,72"},"7":{"d":"54,0v17,-92,80,-153,119,-228r-134,0r0,-32r167,0r0,32v-67,98,-104,175,-112,228r-40,0"},"8":{"d":"117,7v-47,0,-86,-27,-86,-71v0,-31,18,-57,52,-78v-23,-17,-37,-26,-38,-58v0,-42,35,-67,78,-67v38,0,72,20,72,56v0,25,-17,48,-49,69v39,19,59,45,59,75v0,46,-40,74,-88,74xm119,-241v-35,-2,-57,36,-32,60v7,8,21,17,40,28v46,-23,51,-85,-8,-88xm118,-20v39,0,66,-36,43,-67v-9,-11,-41,-30,-59,-41v-23,20,-35,26,-36,59v-1,30,22,49,52,49"},"9":{"d":"204,-140v-2,78,-30,147,-110,147v-14,0,-31,-4,-53,-9r0,-29v77,34,130,-11,125,-93v-44,65,-139,24,-139,-50v0,-50,36,-93,86,-93v63,0,93,58,91,127xm111,-241v-32,0,-49,26,-49,61v0,36,17,63,50,64v29,1,53,-23,53,-51v0,-39,-18,-74,-54,-74"},":":{"d":"40,0r0,-35r34,0r0,35r-34,0xm40,-156r0,-35r34,0r0,35r-34,0","w":113},";":{"d":"40,56v-1,-22,15,-23,12,-56r-12,0r0,-35r34,0v2,43,-2,87,-34,91xm40,-156r0,-35r34,0r0,35r-34,0","w":113},"<":{"d":"247,0r-208,-104r208,-104r0,19r-169,85r169,85r0,19","w":286},"=":{"d":"39,-63r0,-17r208,0r0,17r-208,0xm39,-128r0,-17r208,0r0,17r-208,0","w":286},">":{"d":"39,0r0,-19r169,-85r-169,-85r0,-19r208,104","w":286},"?":{"d":"44,0r0,-35r35,0r0,35r-35,0xm7,-257v67,-28,165,1,132,76v-15,34,-72,49,-60,112r-35,0v-11,-64,64,-91,64,-138v0,-44,-65,-39,-101,-21r0,-29","w":151},"@":{"d":"36,-103v0,73,84,113,150,77r6,18v-79,41,-178,-8,-176,-93v1,-87,71,-164,165,-166v63,-1,115,49,115,111v0,54,-41,103,-91,104v-43,1,-27,-39,-18,-61r-3,0v-21,41,-44,61,-68,61v-21,0,-34,-17,-34,-39v0,-65,41,-127,120,-115r24,0r-23,123v0,8,5,11,14,11v33,0,60,-46,60,-81v0,-54,-44,-94,-99,-94v-71,0,-142,71,-142,144xm195,-181v-57,-25,-85,30,-85,82v0,38,23,27,42,5v16,-19,41,-47,43,-87","w":309},"A":{"d":"3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"B":{"d":"192,-65v0,43,-29,65,-82,65r-76,0r0,-260v67,0,148,-8,148,57v0,35,-24,57,-54,67v43,13,64,37,64,71xm153,-69v0,-36,-40,-57,-83,-54r0,95v51,1,83,-1,83,-41xm70,-146v42,2,72,-10,74,-49v1,-30,-32,-40,-74,-38r0,87","w":207},"C":{"d":"57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91","w":249},"D":{"d":"251,-136v0,82,-43,138,-130,136r-87,0r0,-260r86,0v89,-4,131,43,131,124xm212,-133v1,-83,-50,-107,-142,-100r0,205r48,0v69,1,92,-40,94,-105","w":269},"E":{"d":"34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"F":{"d":"34,0r0,-260r145,0r0,27r-109,0r0,88r92,0r0,27r-92,0r0,118r-36,0","w":193},"G":{"d":"57,-130v0,80,58,128,135,102r0,-84r37,0r0,105v-111,38,-214,-3,-211,-123v2,-84,45,-138,129,-137v26,0,53,4,82,12r0,34v-94,-41,-172,-12,-172,91","w":260},"H":{"d":"34,0r0,-260r36,0r0,110r124,0r0,-110r37,0r0,260r-37,0r0,-123r-124,0r0,123r-36,0","w":264},"I":{"d":"33,0r0,-260r37,0r0,260r-37,0","w":103},"J":{"d":"-32,16v43,15,75,5,75,-48r0,-228r37,0r0,227v2,69,-46,96,-112,81r0,-32","w":111},"K":{"d":"34,0r0,-260r34,0r0,128r105,-128r38,0r-102,124r120,136r-47,0r-114,-132r0,132r-34,0","w":235},"L":{"d":"34,0r0,-260r36,0r0,232r118,0r0,28r-154,0","w":191},"M":{"d":"34,0r0,-260r51,0r72,201r74,-201r46,0r0,260r-35,0r0,-212r-71,195r-36,0r-70,-195r0,212r-31,0","w":310},"N":{"d":"34,0r0,-260r36,0r131,201r0,-201r31,0r0,260r-36,0r-131,-201r0,201r-31,0","w":265},"O":{"d":"262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"P":{"d":"193,-192v-2,64,-52,93,-123,89r0,103r-36,0r0,-260v78,0,161,-11,159,68xm154,-189v0,-43,-38,-45,-84,-44r0,102v49,3,84,-13,84,-58","w":198},"Q":{"d":"140,-267v137,0,163,216,55,262v30,13,61,22,93,28r-23,29v-41,-13,-75,-29,-103,-47v-91,15,-144,-51,-144,-135v0,-78,46,-137,122,-137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"R":{"d":"190,-196v-1,38,-23,62,-53,74r87,122r-45,0r-74,-110r-35,0r0,110r-36,0r0,-260v73,-1,159,-10,156,64xm70,-138v47,2,80,-11,82,-54v2,-34,-38,-44,-82,-41r0,95"},"S":{"d":"163,-110v38,53,-10,117,-78,117v-18,0,-40,-4,-67,-12r0,-36v57,39,145,18,111,-48v-32,-34,-110,-48,-110,-109v0,-65,78,-83,141,-59r0,34v-49,-22,-96,-27,-106,20v2,33,36,41,61,57v22,14,40,24,48,36","w":193},"T":{"d":"95,0r0,-233r-92,0r0,-27r222,0r0,27r-93,0r0,233r-37,0"},"U":{"d":"127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"V":{"d":"105,0r-99,-260r37,0r81,213r77,-213r33,0r-95,260r-34,0","w":235},"W":{"d":"67,0r-67,-260r36,0r53,205r49,-205r36,0r46,203r57,-203r30,0r-73,260r-36,0r-46,-201r-48,201r-37,0","w":307},"X":{"d":"3,0r86,-131r-82,-129r44,0r62,98r66,-98r35,0r-83,126r85,134r-44,0r-66,-103r-68,103r-35,0","w":225},"Y":{"d":"90,0r0,-109r-87,-151r42,0r68,117r72,-117r35,0r-93,151r0,109r-37,0","w":224},"Z":{"d":"17,0r0,-30r139,-203r-131,0r0,-27r176,0r0,27r-140,203r140,0r0,30r-184,0","w":217},"[":{"d":"35,52r0,-330r69,0r0,26r-39,0r0,278r39,0r0,26r-69,0","w":117},"\\":{"d":"150,52r-19,0r-92,-312r18,0","w":188},"]":{"d":"82,-278r0,330r-69,0r0,-26r39,0r0,-278r-39,0r0,-26r69,0","w":117},"^":{"d":"114,-202r-66,133r-30,0r96,-191r95,191r-29,0"},"_":{"d":"15,26r0,-26r150,0r0,26r-150,0","w":180},"`":{"d":"152,-226r-26,0r-57,-56r41,0","w":221},"a":{"d":"35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"b":{"d":"207,-101v0,86,-84,139,-138,79r-4,24r-30,0r0,-280r34,0r0,123v14,-27,36,-40,64,-40v50,0,74,41,74,94xm69,-46v45,47,101,19,101,-52v0,-83,-64,-82,-101,-35r0,87","w":226},"c":{"d":"59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65","w":184},"d":{"d":"20,-89v0,-86,83,-141,137,-80r0,-109r35,0r0,278r-35,0r0,-36v-14,27,-35,40,-63,40v-49,0,-74,-40,-74,-93xm157,-145v-45,-47,-101,-19,-101,52v0,81,64,83,101,36r0,-88","w":226},"e":{"d":"103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"f":{"d":"143,-249v-37,-11,-71,-15,-67,32r0,26r48,0r0,26r-48,0r0,165r-35,0r0,-165r-27,0r0,-26r27,0v-9,-73,35,-107,102,-85r0,27","w":132},"g":{"d":"192,-191v-7,115,35,265,-93,265v-22,0,-44,-4,-64,-11r4,-30v48,25,123,23,118,-47r0,-30v-10,23,-32,39,-62,40v-50,1,-75,-41,-75,-93v0,-80,85,-132,137,-72r0,-22r35,0xm157,-145v-38,-46,-101,-20,-101,48v0,76,67,77,101,31r0,-79","w":224},"h":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-278r34,0r0,123v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"i":{"d":"35,0r0,-191r34,0r0,191r-34,0xm35,-226r0,-34r34,0r0,34r-34,0","w":104},"j":{"d":"-27,37v38,19,67,17,67,-37r0,-191r35,0r0,191v3,67,-49,88,-102,65r0,-28xm40,-226r0,-34r35,0r0,34r-35,0","w":109},"k":{"d":"35,0r0,-278r34,0r0,180r81,-93r37,0r-77,89r93,102r-44,0r-90,-98r0,98r-34,0","w":210},"l":{"d":"35,0r0,-278r34,0r0,278r-34,0","w":104},"m":{"d":"187,-155v24,-56,117,-55,117,16r0,139r-35,0r0,-133v-6,-57,-57,-32,-82,5r0,128r-35,0r0,-133v-7,-56,-57,-33,-83,5r0,128r-34,0r0,-191r34,0r0,36v27,-49,99,-58,118,0","w":336},"n":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"o":{"d":"202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"p":{"d":"207,-101v0,86,-84,139,-138,79r0,91r-34,0r0,-260r34,0r0,36v14,-27,36,-40,64,-40v50,0,74,41,74,94xm69,-46v45,47,101,19,101,-52v0,-83,-64,-82,-101,-35r0,87","w":226},"q":{"d":"20,-89v0,-86,83,-141,137,-80r0,-22r35,0r0,260r-35,0r0,-105v-14,27,-35,40,-63,40v-49,0,-74,-40,-74,-93xm157,-145v-45,-47,-101,-19,-101,52v0,81,64,83,101,36r0,-88","w":226},"r":{"d":"35,0r0,-191r34,0r0,36v16,-30,37,-43,71,-39r0,32v-33,-10,-52,6,-71,36r0,126r-34,0","w":147},"s":{"d":"144,-86v41,67,-42,113,-116,79r0,-31v23,11,42,16,59,16v18,0,34,-11,34,-28v0,-19,-30,-32,-48,-38v-68,-22,-52,-107,22,-107v12,0,33,2,47,6r0,29v-34,-11,-74,-19,-80,15v1,30,70,37,82,59","w":183},"t":{"d":"120,0v-46,14,-84,-7,-84,-53r0,-112r-24,0r0,-26r24,0r0,-35r35,-3r0,38r50,0r0,26r-50,0r0,106v-1,32,20,42,49,35r0,24","w":134},"u":{"d":"67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"v":{"d":"74,0r-71,-191r35,0r55,149r59,-149r32,0r-75,191r-35,0","w":186},"w":{"d":"57,0r-55,-191r34,0r42,148r45,-148r35,0r39,148r48,-148r30,0r-62,191r-35,0r-41,-148r-45,148r-35,0","w":277},"x":{"d":"15,0r73,-99r-70,-92r41,0r55,74r51,-74r34,0r-66,97r71,94r-41,0r-57,-76r-56,76r-35,0","w":220},"y":{"d":"46,69r31,-69r-74,-191r37,0r55,144r58,-144r33,0r-104,260r-36,0","w":188},"z":{"d":"22,0r0,-26r118,-139r-113,0r0,-26r155,0r0,26r-118,139r121,0r0,26r-163,0","w":206},"{":{"d":"93,52v-55,1,-73,-47,-56,-99v9,-28,3,-60,-33,-53r0,-26v77,6,-4,-101,43,-135v12,-9,26,-16,46,-17r0,26v-47,-2,-26,46,-25,84v0,22,-9,40,-26,55v34,25,27,73,19,117v1,14,14,24,32,22r0,26","w":117},"|":{"d":"59,52r0,-330r17,0r0,330r-17,0","w":134},"}":{"d":"24,-278v54,0,73,47,56,99v-9,27,-3,60,33,53r0,26v-77,-5,4,101,-43,136v-12,9,-26,15,-46,16r0,-26v50,3,25,-45,25,-84v0,-22,9,-40,26,-55v-35,-24,-27,-75,-18,-117v-1,-14,-16,-23,-33,-22r0,-26","w":117},"~":{"d":"79,-107v-20,-12,-35,9,-35,29r-26,0v-1,-49,44,-74,87,-45v23,15,77,48,78,-7r26,0v-1,92,-89,48,-130,23"},"\u00c4":{"d":"3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113xm74,-282r0,-30r30,0r0,30r-30,0xm143,-282r0,-30r30,0r0,30r-30,0","w":248},"\u00c5":{"d":"164,-322v0,22,-19,40,-40,40v-21,0,-39,-19,-39,-40v0,-21,18,-40,39,-40v21,0,40,18,40,40xm100,-322v0,13,11,25,24,25v14,0,25,-11,25,-25v0,-14,-12,-25,-25,-25v-13,0,-24,12,-24,25xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u00c7":{"d":"57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91xm176,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":249},"\u00c9":{"d":"34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0xm80,-282r43,-56r40,0r-57,56r-26,0","w":195},"\u00d1":{"d":"79,-282v-1,-58,55,-39,81,-22v8,0,13,-6,14,-19r22,0v1,46,-41,47,-67,28v-15,-11,-26,-8,-29,13r-21,0xm34,0r0,-260r36,0r131,201r0,-201r31,0r0,260r-36,0r-131,-201r0,201r-31,0","w":265},"\u00d6":{"d":"262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109xm90,-282r0,-30r30,0r0,30r-30,0xm159,-282r0,-30r30,0r0,30r-30,0","w":279},"\u00dc":{"d":"127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102xm75,-282r0,-30r30,0r0,30r-30,0xm144,-282r0,-30r30,0r0,30r-30,0","w":249},"\u00e1":{"d":"35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38xm74,-226r43,-56r40,0r-57,56r-26,0","w":198},"\u00e0":{"d":"35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38xm127,-226r-26,0r-57,-56r41,0","w":198},"\u00e2":{"d":"39,-226r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u00e4":{"d":"35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38xm50,-226r0,-30r30,0r0,30r-30,0xm119,-226r0,-30r30,0r0,30r-30,0","w":198},"\u00e3":{"d":"41,-226v-2,-46,42,-47,67,-27v15,12,26,8,29,-14r21,0v2,46,-41,48,-67,28v-15,-11,-26,-9,-28,13r-22,0xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u00e5":{"d":"140,-265v0,21,-19,39,-40,39v-21,0,-40,-18,-40,-39v0,-21,18,-40,40,-40v22,0,40,19,40,40xm75,-265v0,13,12,24,25,24v13,0,25,-12,25,-24v0,-13,-11,-25,-25,-25v-14,0,-25,11,-25,25xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u00e7":{"d":"59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65xm144,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":184},"\u00e9":{"d":"103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53xm74,-226r43,-56r40,0r-57,56r-26,0","w":200},"\u00e8":{"d":"103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53xm126,-226r-26,0r-57,-56r41,0","w":200},"\u00ea":{"d":"41,-226r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u00eb":{"d":"103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53xm54,-226r0,-30r30,0r0,30r-30,0xm123,-226r0,-30r30,0r0,30r-30,0","w":200},"\u00ed":{"d":"35,0r0,-191r34,0r0,191r-34,0xm26,-226r43,-56r40,0r-57,56r-26,0","w":104},"\u00ec":{"d":"35,0r0,-191r34,0r0,191r-34,0xm78,-226r-26,0r-57,-56r41,0","w":104},"\u00ee":{"d":"-9,-226r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm35,0r0,-191r34,0r0,191r-34,0","w":104},"\u00ef":{"d":"35,0r0,-191r34,0r0,191r-34,0xm2,-226r0,-30r30,0r0,30r-30,0xm71,-226r0,-30r30,0r0,30r-30,0","w":104},"\u00f1":{"d":"59,-226v-2,-47,41,-47,66,-27v15,12,26,8,29,-14r22,0v2,45,-42,48,-67,28v-15,-12,-26,-8,-29,13r-21,0xm156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"\u00f3":{"d":"202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74xm84,-226r43,-56r40,0r-57,56r-26,0","w":221},"\u00f2":{"d":"202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74xm137,-226r-26,0r-57,-56r41,0","w":221},"\u00f4":{"d":"49,-226r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"\u00f6":{"d":"202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74xm61,-226r0,-30r30,0r0,30r-30,0xm130,-226r0,-30r30,0r0,30r-30,0","w":221},"\u00f5":{"d":"52,-226v-2,-46,42,-47,67,-27v15,12,26,8,28,-14r22,0v2,46,-41,48,-67,28v-15,-11,-26,-9,-28,13r-22,0xm202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"\u00fa":{"d":"67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126xm84,-226r43,-56r40,0r-57,56r-26,0","w":223},"\u00f9":{"d":"67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126xm137,-226r-26,0r-57,-56r41,0","w":223},"\u00fb":{"d":"49,-226r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u00fc":{"d":"67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126xm61,-226r0,-30r30,0r0,30r-30,0xm130,-226r0,-30r30,0r0,30r-30,0","w":223},"\u00b0":{"d":"89,-228v0,21,-18,39,-39,39v-21,0,-39,-19,-39,-39v0,-20,19,-39,39,-39v20,-1,39,18,39,39xm29,-228v0,12,10,22,21,22v12,0,21,-11,22,-22v0,-11,-10,-21,-22,-21v-12,0,-21,9,-21,21","w":99},"\u00a2":{"d":"36,-130v0,-56,31,-92,81,-98r0,-32r17,0r0,32v16,1,32,3,50,8r0,30v-21,-7,-37,-12,-50,-13r0,148v16,0,33,-4,50,-12r0,26v-17,7,-34,11,-50,11r0,30r-17,0r0,-30v-47,-4,-81,-47,-81,-100xm117,-57r0,-144v-28,3,-43,26,-43,72v0,39,15,63,43,72"},"\u00a3":{"d":"115,-126v1,48,-1,76,-30,96r107,0r0,30r-149,0r0,-30v38,-10,39,-49,37,-96r-31,0r0,-26r31,0v-5,-65,9,-116,69,-115v12,0,26,2,40,6r0,29v-34,-15,-74,-15,-74,32r0,48r38,0r0,26r-38,0"},"\u00a7":{"d":"194,-2v0,65,-91,73,-155,48r0,-32v28,12,52,19,72,19v34,0,65,-24,44,-51v-29,-23,-115,-41,-115,-90v0,-18,8,-35,25,-52v-55,-38,-8,-107,58,-107v18,0,38,3,61,9r0,28v-44,-14,-103,-22,-112,22v1,27,35,30,55,41v62,16,85,69,38,118v19,11,29,27,29,47xm148,-60v26,-33,8,-57,-26,-72r-39,-17v-24,32,-15,57,27,73"},"\u00b6":{"d":"38,-203v0,-69,76,-56,143,-57r0,312r-22,0r0,-291r-26,0r0,291r-21,0r0,-182v-43,-3,-74,-28,-74,-73"},"\u00df":{"d":"118,-111v-52,-35,10,-77,10,-118v0,-18,-10,-27,-30,-27v-19,0,-29,13,-29,39r0,217r-34,0r0,-202v0,-55,13,-79,64,-80v33,0,64,14,64,46v5,18,-32,59,-36,77v10,35,78,61,78,106v0,56,-64,69,-111,47r0,-30v21,9,37,14,49,14v36,1,36,-46,9,-60","w":215},"\u00ae":{"d":"192,-189v0,43,-35,78,-78,78v-43,0,-78,-35,-78,-78v0,-42,36,-78,78,-78v42,0,78,36,78,78xm53,-189v0,33,28,61,61,61v33,0,61,-28,61,-61v0,-33,-28,-60,-61,-60v-33,0,-61,28,-61,60xm82,-141r0,-93v28,-1,63,-2,63,24v0,11,-6,20,-19,27r22,42r-20,0r-20,-38r-8,0r0,38r-18,0xm100,-192v27,7,38,-30,8,-29r-8,0r0,29"},"\u00a9":{"d":"291,-130v0,74,-64,137,-137,137v-73,0,-137,-64,-137,-137v0,-74,63,-137,137,-137v74,0,137,63,137,137xm37,-130v0,61,53,117,117,117v64,0,117,-56,117,-117v0,-61,-53,-117,-117,-117v-64,0,-117,56,-117,117xm110,-130v0,53,51,72,94,48r0,21v-60,26,-121,-6,-121,-68v0,-65,55,-90,121,-73r0,22v-46,-24,-94,-3,-94,50","w":307},"\u2122":{"d":"55,-130r0,-112r-46,0r0,-18r120,0r0,18r-47,0r0,112r-27,0xm151,-130r0,-130r36,0r31,91r32,-91r32,0r0,130r-26,0r0,-98r-31,89r-22,0r-31,-91r0,100r-21,0","w":290},"\u00b4":{"d":"69,-226r43,-56r40,0r-57,56r-26,0","w":221},"\u00a8":{"d":"61,-226r0,-30r30,0r0,30r-30,0xm130,-226r0,-30r30,0r0,30r-30,0","w":221},"\u00c6":{"d":"3,0r152,-260r155,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-154,0r0,-73r-85,0r-42,73r-34,0xm95,-100r69,0r0,-118","w":326},"\u00d8":{"d":"193,-219v-61,-51,-136,2,-136,89v0,27,5,50,15,69xm87,-41v60,51,135,-2,135,-89v0,-28,-4,-50,-14,-69xm230,-228v66,77,26,235,-90,235v-29,0,-52,-8,-72,-23r-17,23r-31,0r30,-39v-66,-77,-28,-235,90,-235v28,0,51,7,72,22r17,-22r31,0","w":279},"\u00b1":{"d":"39,0r0,-17r208,0r0,17r-208,0xm134,-52r0,-69r-95,0r0,-18r95,0r0,-69r18,0r0,69r95,0r0,18r-95,0r0,69r-18,0","w":286},"\u00a5":{"d":"95,0r0,-61r-52,0r0,-26r52,0r0,-17r-52,0r0,-26r52,0r-81,-130r41,0r63,101r69,-101r31,0r-88,130r52,0r0,26r-52,0r0,17r52,0r0,26r-52,0r0,61r-35,0"},"\u00b5":{"d":"35,69r0,-260r34,0r0,126v5,59,65,40,87,-2r0,-124r35,0r0,191r-35,0r0,-36v-22,38,-50,50,-87,32r0,73r-34,0","w":225},"\u00aa":{"d":"22,-192v0,-30,30,-42,66,-40v7,-38,-32,-36,-56,-21r0,-19v33,-14,85,-12,82,28v4,22,-11,69,14,66r1,15v-17,6,-35,4,-39,-13v-21,26,-68,20,-68,-16xm88,-217v-38,-7,-56,31,-24,38v8,0,15,-4,24,-11r0,-27","w":151},"\u00ba":{"d":"136,-220v0,37,-21,60,-57,60v-36,0,-57,-24,-57,-60v0,-37,21,-60,57,-60v36,0,57,24,57,60xm79,-177v20,0,29,-15,29,-43v0,-28,-9,-43,-29,-43v-20,0,-30,15,-30,43v0,28,10,43,30,43","w":151},"\u00e6":{"d":"18,-48v1,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29v42,-17,91,-23,119,7v56,-47,136,-14,127,84r-118,0v2,70,61,80,118,56r0,27v-56,18,-111,17,-139,-27v-22,26,-45,38,-69,38v-32,0,-55,-22,-55,-52xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38xm164,-114r80,0v0,-37,-13,-55,-38,-55v-25,0,-39,18,-42,55","w":306},"\u00f8":{"d":"179,-166v47,59,19,170,-68,170v-20,0,-39,-5,-54,-15r-11,15r-26,0r22,-29v-47,-58,-18,-170,69,-170v21,0,38,5,53,15r12,-15r26,0xm76,-34v41,33,89,-5,89,-61v0,-16,-3,-30,-8,-43xm145,-156v-41,-34,-89,4,-89,60v0,17,3,32,8,44","w":221},"\u00bf":{"d":"108,-191r0,35r-35,0r0,-35r35,0xm145,66v-67,27,-164,0,-133,-76v14,-34,73,-49,61,-111r35,0v10,64,-65,90,-65,137v0,44,66,39,102,21r0,29","w":151},"\u00a1":{"d":"74,-191r0,35r-34,0r0,-35r34,0xm70,-121r4,190r-34,0r4,-190r26,0","w":113},"\u00ac":{"d":"230,-52r0,-69r-191,0r0,-18r208,0r0,87r-17,0","w":286},"\u00ab":{"d":"176,-160r-52,65r52,65r-18,13r-69,-78r69,-78xm106,-160r-52,65r52,65r-17,13r-69,-78r69,-78","w":188},"\u00bb":{"d":"13,-30r52,-65r-52,-65r17,-13r70,78r-70,78xm82,-30r52,-65r-52,-65r18,-13r69,78r-69,78","w":188},"\u2026":{"d":"43,0r0,-35r34,0r0,35r-34,0xm163,0r0,-35r34,0r0,35r-34,0xm283,0r0,-35r34,0r0,35r-34,0","w":360},"\u00a0":{"w":113},"\u00c0":{"d":"3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113xm151,-282r-26,0r-57,-56r41,0","w":248},"\u00c3":{"d":"65,-282v-1,-46,41,-47,67,-28v15,11,26,9,28,-13r22,0v2,47,-41,47,-67,28v-15,-11,-26,-9,-28,13r-22,0xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u00d5":{"d":"81,-282v-2,-46,41,-47,67,-28v15,11,26,8,29,-13r21,0v2,46,-40,48,-66,28v-15,-11,-26,-8,-29,13r-22,0xm262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"\u0152":{"d":"18,-130v0,-101,93,-171,180,-120r0,-10r146,0r0,27r-109,0r0,84r91,0r0,27r-90,0r-1,94r116,0r0,28r-153,0r0,-10v-87,51,-180,-19,-180,-120xm140,-21v66,2,58,-73,58,-139v-1,-49,-12,-79,-59,-79v-57,0,-82,48,-82,109v-1,62,27,107,83,109","w":360},"\u0153":{"d":"309,-7v-54,18,-113,16,-137,-24v-44,71,-163,25,-152,-64v-10,-88,105,-137,151,-65v14,-23,36,-35,64,-35v49,0,74,35,74,105r-119,0v2,70,62,81,119,56r0,27xm56,-95v0,41,16,73,54,73v30,0,45,-25,45,-76v0,-47,-15,-71,-45,-71v-39,0,-54,33,-54,74xm192,-114r80,0v0,-37,-13,-55,-38,-55v-25,0,-39,18,-42,55","w":334},"\u2013":{"d":"18,-95r0,-22r144,0r0,22r-144,0","w":180},"\u2014":{"d":"17,-95r0,-22r326,0r0,22r-326,0","w":360},"\u201c":{"d":"115,-278v1,23,-16,23,-13,57r13,0r0,34r-35,0v-2,-44,3,-86,35,-91xm54,-278v1,22,-15,24,-12,57r12,0r0,34r-34,0v-2,-43,3,-87,34,-91","w":134},"\u201d":{"d":"20,-187v-1,-22,15,-23,12,-56r-12,0r0,-35r34,0v2,43,-2,87,-34,91xm80,-187v-1,-23,16,-22,13,-56r-13,0r0,-35r35,0v2,44,-3,87,-35,91","w":134},"\u2018":{"d":"79,-278r0,13v-12,2,-18,21,-17,44r17,0r0,43r-44,0v-3,-50,2,-99,44,-100","w":113},"\u2019":{"d":"35,-178r0,-13v12,-3,18,-20,17,-43r-17,0r0,-44r44,0v3,50,-2,100,-44,100","w":113},"\u00f7":{"d":"126,-17r0,-35r34,0r0,35r-34,0xm39,-95r0,-18r208,0r0,18r-208,0xm126,-156r0,-35r34,0r0,35r-34,0","w":286},"\u00ff":{"d":"46,69r31,-69r-74,-191r37,0r55,144r58,-144r33,0r-104,260r-36,0xm47,-226r0,-30r30,0r0,30r-30,0xm116,-226r0,-30r30,0r0,30r-30,0","w":188},"\u0178":{"d":"90,0r0,-109r-87,-151r42,0r68,117r72,-117r35,0r-93,151r0,109r-37,0xm62,-282r0,-30r30,0r0,30r-30,0xm131,-282r0,-30r30,0r0,30r-30,0","w":224},"\u00c2":{"d":"63,-282r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u00ca":{"d":"47,-282r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u00c1":{"d":"3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113xm98,-282r43,-56r40,0r-57,56r-26,0","w":248},"\u00cb":{"d":"34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0xm60,-282r0,-30r30,0r0,30r-30,0xm129,-282r0,-30r30,0r0,30r-30,0","w":195},"\u00c8":{"d":"34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0xm135,-282r-26,0r-57,-56r41,0","w":195},"\u00cd":{"d":"33,0r0,-260r37,0r0,260r-37,0xm25,-282r43,-56r40,0r-57,56r-26,0","w":103},"\u00ce":{"d":"-10,-282r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u00cf":{"d":"33,0r0,-260r37,0r0,260r-37,0xm2,-282r0,-30r30,0r0,30r-30,0xm71,-282r0,-30r30,0r0,30r-30,0","w":103},"\u00cc":{"d":"33,0r0,-260r37,0r0,260r-37,0xm78,-282r-26,0r-57,-56r41,0","w":103},"\u00d3":{"d":"262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109xm113,-282r43,-56r40,0r-57,56r-26,0","w":279},"\u00d4":{"d":"78,-282r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"\u00d2":{"d":"262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109xm166,-282r-26,0r-57,-56r41,0","w":279},"\u00da":{"d":"127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102xm101,-282r43,-56r40,0r-57,56r-26,0","w":249},"\u00db":{"d":"66,-282r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u00d9":{"d":"127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102xm153,-282r-26,0r-57,-56r41,0","w":249},"\u0131":{"d":"35,0r0,-191r34,0r0,191r-34,0","w":104},"\u00b8":{"d":"151,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":221},"\u0141":{"d":"34,0r0,-109r-39,21r0,-30r39,-22r0,-120r36,0r0,100r39,-21r0,31r-39,21r0,101r118,0r0,28r-154,0","w":191},"\u0142":{"d":"34,0r0,-119r-39,21r0,-30r39,-21r0,-129r35,0r0,110r39,-20r0,29r-39,21r0,138r-35,0","w":104},"\u0160":{"d":"162,-338r-42,56r-38,0r-43,-56r26,0r36,35r35,-35r26,0xm163,-110v38,53,-10,117,-78,117v-18,0,-40,-4,-67,-12r0,-36v57,39,145,18,111,-48v-32,-34,-110,-48,-110,-109v0,-65,78,-83,141,-59r0,34v-49,-22,-96,-27,-106,20v2,33,36,41,61,57v22,14,40,24,48,36","w":193},"\u0161":{"d":"153,-282r-42,56r-39,0r-42,-56r26,0r36,36r35,-36r26,0xm144,-86v41,67,-42,113,-116,79r0,-31v23,11,42,16,59,16v18,0,34,-11,34,-28v0,-19,-30,-32,-48,-38v-68,-22,-52,-107,22,-107v12,0,33,2,47,6r0,29v-34,-11,-74,-19,-80,15v1,30,70,37,82,59","w":183},"\u017d":{"d":"176,-338r-42,56r-38,0r-43,-56r26,0r36,35r35,-35r26,0xm17,0r0,-30r139,-203r-131,0r0,-27r176,0r0,27r-140,203r140,0r0,30r-184,0","w":217},"\u017e":{"d":"164,-282r-42,56r-38,0r-43,-56r26,0r36,36r35,-36r26,0xm22,0r0,-26r118,-139r-113,0r0,-26r155,0r0,26r-118,139r121,0r0,26r-163,0","w":206},"\u00a6":{"d":"59,52r0,-130r17,0r0,130r-17,0xm59,-147r0,-131r17,0r0,131r-17,0","w":133},"\u00d0":{"d":"252,-136v0,81,-43,138,-131,136r-87,0r0,-119r-39,0r0,-28r39,0r0,-113r86,0v89,-4,132,44,132,124xm212,-133v0,-82,-49,-108,-141,-100r0,86r58,0r0,28r-58,0r0,91r47,0v69,1,93,-39,94,-105","w":269},"\u00f0":{"d":"19,-95v0,-63,46,-108,111,-93v-9,-17,-23,-32,-43,-44r-30,30r-15,-15r26,-26v-14,-6,-31,-9,-49,-9r0,-26v26,0,49,5,70,14r30,-30r15,15r-25,26v49,32,86,81,88,152v1,60,-33,105,-89,105v-55,0,-89,-43,-89,-99xm56,-94v0,40,16,72,53,72v35,-1,53,-33,53,-74v0,-47,-17,-70,-52,-70v-38,0,-54,32,-54,72","w":216},"\u00dd":{"d":"90,0r0,-109r-87,-151r42,0r68,117r72,-117r35,0r-93,151r0,109r-37,0xm86,-282r43,-56r40,0r-57,56r-26,0","w":224},"\u00fd":{"d":"46,69r31,-69r-74,-191r37,0r55,144r58,-144r33,0r-104,260r-36,0xm68,-226r43,-56r40,0r-57,56r-26,0","w":188},"\u00de":{"d":"193,-140v0,64,-52,93,-123,88r0,52r-36,0r0,-260r36,0r0,51v68,-2,123,3,123,69xm154,-138v0,-43,-38,-44,-84,-43r0,102v51,4,84,-13,84,-59","w":198},"\u00fe":{"d":"207,-101v0,86,-84,139,-138,79r0,91r-34,0r0,-347r34,0r0,123v14,-27,36,-40,64,-40v50,0,74,41,74,94xm69,-46v45,47,101,19,101,-52v0,-83,-64,-82,-101,-35r0,87","w":226},"\u00d7":{"d":"39,-12r92,-92r-92,-92r12,-12r92,92r92,-92r12,12r-92,92r92,92r-12,12r-92,-92r-92,92","w":286},"\u00b9":{"d":"72,-104r0,-139r-26,0r0,-15r52,-4r0,158r-26,0","w":151},"\u00b2":{"d":"30,-255v47,-27,120,7,88,59v-11,19,-58,46,-62,70r69,0r0,22r-99,0v-7,-57,72,-69,72,-116v0,-34,-43,-30,-68,-14r0,-21","w":151},"\u00b3":{"d":"28,-127v30,14,66,14,69,-19v2,-24,-22,-34,-55,-32r0,-17v30,2,52,-8,51,-29v-1,-29,-41,-27,-63,-14r0,-20v34,-12,89,-8,89,31v0,18,-11,31,-33,39v26,6,38,20,38,42v0,45,-53,53,-96,41r0,-22","w":151},"\u00bd":{"d":"18,7r191,-274r24,0r-192,274r-23,0xm44,-104r0,-139r-26,0r0,-15r52,-4r0,158r-26,0xm176,-151v47,-27,120,7,88,59v-11,19,-58,46,-62,70r69,0r0,22r-99,0v-7,-57,72,-69,72,-116v0,-34,-43,-30,-68,-14r0,-21","w":288},"\u00bc":{"d":"226,0r0,-43r-72,0r0,-20r71,-93r24,0r0,93r22,0r0,20r-22,0r0,43r-23,0xm177,-63r49,0r0,-64xm26,7r192,-274r23,0r-191,274r-24,0xm44,-104r0,-139r-26,0r0,-15r52,-4r0,158r-26,0","w":288},"\u00be":{"d":"226,0r0,-43r-72,0r0,-20r71,-93r24,0r0,93r22,0r0,20r-22,0r0,43r-23,0xm177,-63r49,0r0,-64xm44,7r191,-274r24,0r-191,274r-24,0xm18,-127v30,14,66,14,69,-19v2,-24,-22,-34,-55,-32r0,-17v30,2,52,-8,51,-29v-1,-29,-41,-27,-63,-14r0,-20v34,-12,89,-8,89,31v0,18,-11,31,-33,39v26,6,38,20,38,42v0,45,-53,53,-96,41r0,-22","w":288},"\u011e":{"d":"200,-334v-1,47,-65,68,-99,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r22,0xm57,-130v0,80,58,128,135,102r0,-84r37,0r0,105v-111,38,-214,-3,-211,-123v2,-84,45,-138,129,-137v26,0,53,4,82,12r0,34v-94,-41,-172,-12,-172,91","w":260},"\u011f":{"d":"164,-278v0,47,-64,67,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r21,0xm192,-191v-7,115,35,265,-93,265v-22,0,-44,-4,-64,-11r4,-30v48,25,123,23,118,-47r0,-30v-10,23,-32,39,-62,40v-50,1,-75,-41,-75,-93v0,-80,85,-132,137,-72r0,-22r35,0xm157,-145v-38,-46,-101,-20,-101,48v0,76,67,77,101,31r0,-79","w":224},"\u0130":{"d":"34,-282r0,-35r35,0r0,35r-35,0xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u015e":{"d":"163,-110v38,53,-10,117,-78,117v-18,0,-40,-4,-67,-12r0,-36v57,39,145,18,111,-48v-32,-34,-110,-48,-110,-109v0,-65,78,-83,141,-59r0,34v-49,-22,-96,-27,-106,20v2,33,36,41,61,57v22,14,40,24,48,36xm129,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":193},"\u015f":{"d":"144,-86v41,67,-42,113,-116,79r0,-31v23,11,42,16,59,16v18,0,34,-11,34,-28v0,-19,-30,-32,-48,-38v-68,-22,-52,-107,22,-107v12,0,33,2,47,6r0,29v-34,-11,-74,-19,-80,15v1,30,70,37,82,59xm127,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":183},"\u0106":{"d":"57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91xm115,-282r43,-56r40,0r-57,56r-26,0","w":249},"\u0107":{"d":"59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65xm78,-226r43,-56r40,0r-57,56r-26,0","w":184},"\u010c":{"d":"207,-338r-43,56r-38,0r-43,-56r27,0r35,35r36,-35r26,0xm57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91","w":249},"\u010d":{"d":"170,-282r-43,56r-38,0r-42,-56r26,0r35,36r36,-36r26,0xm59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65","w":184},"\u0111":{"d":"20,-89v0,-86,83,-141,137,-80r0,-48r-45,0r0,-22r45,0r0,-39r35,0r0,39r35,0r0,22r-35,0r0,217r-35,0r0,-36v-14,27,-35,40,-63,40v-49,0,-74,-40,-74,-93xm157,-145v-45,-47,-101,-19,-101,52v0,81,64,83,101,36r0,-88","w":226},"\u00ad":{"d":"20,-95r0,-26r78,0r0,26r-78,0","w":117},"\u00af":{"d":"15,-256r0,-26r150,0r0,26r-150,0","w":180},"\u00b7":{"d":"92,-82r0,-44r44,0r0,44r-44,0"},"\u0100":{"d":"68,-282r0,-26r113,0r0,26r-113,0xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u0101":{"d":"40,-226r0,-26r113,0r0,26r-113,0xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u0102":{"d":"182,-334v-1,46,-64,68,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,70,35,73,0r22,0xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u0103":{"d":"163,-278v-1,47,-65,68,-99,38v-11,-9,-16,-22,-18,-38r21,0v3,34,71,35,74,0r22,0xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u0104":{"d":"237,60v-22,11,-60,4,-60,-23v0,-17,15,-41,46,-37v-15,9,-22,19,-22,31v0,17,22,20,36,15r0,14xm3,0r103,-260r37,0r101,260r-40,0r-28,-72r-110,0r-29,72r-34,0xm77,-99r88,0r-44,-113","w":248},"\u0105":{"d":"184,60v-22,11,-60,4,-60,-23v0,-17,16,-41,47,-37v-15,9,-23,19,-23,31v0,17,22,20,36,15r0,14xm35,-181v53,-23,128,-24,128,45r0,87v1,23,6,31,25,29r2,19v-25,10,-52,6,-57,-23v-39,44,-115,36,-115,-24v0,-52,51,-66,110,-65v2,-33,-2,-58,-35,-56v-18,0,-37,6,-58,17r0,-29xm53,-54v0,38,49,37,75,11r0,-49v-35,-4,-75,7,-75,38","w":198},"\u0108":{"d":"84,-282r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91","w":249},"\u0109":{"d":"46,-226r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65","w":184},"\u010a":{"d":"128,-282r0,-35r35,0r0,35r-35,0xm57,-130v0,99,94,135,172,85r0,32v-96,50,-211,4,-211,-117v0,-117,98,-162,211,-125r0,34v-95,-40,-172,-12,-172,91","w":249},"\u010b":{"d":"96,-226r0,-34r34,0r0,34r-34,0xm59,-95v0,62,56,89,108,59r0,30v-80,32,-147,-12,-147,-91v0,-80,66,-113,145,-92r0,29v-60,-25,-106,2,-106,65","w":184},"\u010e":{"d":"193,-338r-43,56r-38,0r-42,-56r26,0r35,35r36,-35r26,0xm251,-136v0,82,-43,138,-130,136r-87,0r0,-260r86,0v89,-4,131,43,131,124xm212,-133v1,-83,-50,-107,-142,-100r0,205r48,0v69,1,92,-40,94,-105","w":269},"\u010f":{"d":"227,-198r0,-10v10,-1,13,-16,13,-35r-13,0r0,-35r34,0v2,39,-1,80,-34,80xm20,-89v0,-86,83,-141,137,-80r0,-109r35,0r0,278r-35,0r0,-36v-14,27,-35,40,-63,40v-49,0,-74,-40,-74,-93xm157,-145v-45,-47,-101,-19,-101,52v0,81,64,83,101,36r0,-88","w":278},"\u0110":{"d":"252,-136v0,81,-43,138,-131,136r-87,0r0,-119r-39,0r0,-28r39,0r0,-113r86,0v89,-4,132,44,132,124xm212,-133v0,-82,-49,-108,-141,-100r0,86r58,0r0,28r-58,0r0,91r47,0v69,1,93,-39,94,-105","w":269},"\u0112":{"d":"55,-282r0,-26r113,0r0,26r-113,0xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u0113":{"d":"48,-226r0,-26r113,0r0,26r-113,0xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u0114":{"d":"169,-334v-1,47,-65,68,-99,38v-11,-9,-16,-22,-18,-38r21,0v3,34,71,35,74,0r22,0xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u0115":{"d":"163,-278v-1,46,-64,68,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r21,0xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u0116":{"d":"91,-282r0,-35r35,0r0,35r-35,0xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u0117":{"d":"85,-226r0,-34r34,0r0,34r-34,0xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u0118":{"d":"180,60v-22,11,-61,4,-60,-23v0,-17,15,-40,46,-37v-15,9,-22,19,-22,31v0,17,22,20,36,15r0,14xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u0119":{"d":"154,60v-22,11,-60,4,-60,-23v0,-17,16,-41,47,-37v-15,9,-23,19,-23,31v0,17,22,20,36,15r0,14xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u011a":{"d":"171,-338r-42,56r-38,0r-43,-56r26,0r36,35r35,-35r26,0xm34,0r0,-260r145,0r0,27r-109,0r0,84r91,0r0,27r-91,0r0,94r117,0r0,28r-153,0","w":195},"\u011b":{"d":"162,-282r-43,56r-38,0r-43,-56r27,0r35,36r36,-36r26,0xm103,-195v54,1,76,44,72,105r-120,0v6,69,60,81,120,56r0,28v-81,31,-155,-8,-155,-90v0,-53,32,-100,83,-99xm56,-116r85,0v0,-36,-14,-53,-40,-53v-27,0,-42,17,-45,53","w":200},"\u011c":{"d":"84,-282r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm57,-130v0,80,58,128,135,102r0,-84r37,0r0,105v-111,38,-214,-3,-211,-123v2,-84,45,-138,129,-137v26,0,53,4,82,12r0,34v-94,-41,-172,-12,-172,91","w":260},"\u011d":{"d":"49,-226r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm192,-191v-7,115,35,265,-93,265v-22,0,-44,-4,-64,-11r4,-30v48,25,123,23,118,-47r0,-30v-10,23,-32,39,-62,40v-50,1,-75,-41,-75,-93v0,-80,85,-132,137,-72r0,-22r35,0xm157,-145v-38,-46,-101,-20,-101,48v0,76,67,77,101,31r0,-79","w":224},"\u0120":{"d":"128,-282r0,-35r35,0r0,35r-35,0xm57,-130v0,80,58,128,135,102r0,-84r37,0r0,105v-111,38,-214,-3,-211,-123v2,-84,45,-138,129,-137v26,0,53,4,82,12r0,34v-94,-41,-172,-12,-172,91","w":260},"\u0121":{"d":"90,-226r0,-34r35,0r0,34r-35,0xm192,-191v-7,115,35,265,-93,265v-22,0,-44,-4,-64,-11r4,-30v48,25,123,23,118,-47r0,-30v-10,23,-32,39,-62,40v-50,1,-75,-41,-75,-93v0,-80,85,-132,137,-72r0,-22r35,0xm157,-145v-38,-46,-101,-20,-101,48v0,76,67,77,101,31r0,-79","w":224},"\u0122":{"d":"57,-130v0,80,58,128,135,102r0,-84r37,0r0,105v-111,38,-214,-3,-211,-123v2,-84,45,-138,129,-137v26,0,53,4,82,12r0,34v-94,-41,-172,-12,-172,91xm180,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":260},"\u0123":{"d":"123,-305r0,10v-10,1,-13,16,-13,35r13,0r0,34r-34,0v-2,-39,1,-80,34,-79xm192,-191v-7,115,35,265,-93,265v-22,0,-44,-4,-64,-11r4,-30v48,25,123,23,118,-47r0,-30v-10,23,-32,39,-62,40v-50,1,-75,-41,-75,-93v0,-80,85,-132,137,-72r0,-22r35,0xm157,-145v-38,-46,-101,-20,-101,48v0,76,67,77,101,31r0,-79","w":224},"\u0124":{"d":"71,-282r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0xm34,0r0,-260r36,0r0,110r124,0r0,-110r37,0r0,260r-37,0r0,-123r-124,0r0,123r-36,0","w":264},"\u0125":{"d":"-9,-295r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-278r34,0r0,123v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"\u0126":{"d":"204,-150r0,-41r-124,0r0,41r124,0xm241,0r-37,0r0,-123r-124,0r0,123r-37,0r0,-191r-34,0r0,-26r34,0r0,-43r37,0r0,43r124,0r0,-43r37,0r0,43r34,0r0,26r-34,0r0,191","w":284},"\u0127":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-217r-35,0r0,-22r35,0r0,-39r34,0r0,39r52,0r0,22r-52,0r0,62v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"\u0128":{"d":"-7,-282v-2,-46,41,-47,67,-28v15,11,26,8,29,-13r21,0v2,46,-40,48,-66,28v-15,-11,-26,-8,-29,13r-22,0xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u0129":{"d":"-7,-226v-2,-46,42,-47,67,-27v15,12,26,8,29,-14r22,0v2,45,-42,48,-67,28v-15,-12,-26,-8,-29,13r-22,0xm35,0r0,-191r34,0r0,191r-34,0","w":104},"\u012a":{"d":"-5,-282r0,-26r113,0r0,26r-113,0xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u012b":{"d":"-4,-226r0,-26r112,0r0,26r-112,0xm35,0r0,-191r34,0r0,191r-34,0","w":104},"\u012c":{"d":"110,-334v0,47,-64,67,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r21,0xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u012d":{"d":"111,-278v-1,47,-65,68,-99,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r22,0xm35,0r0,-191r34,0r0,191r-34,0","w":104},"\u012e":{"d":"84,60v-22,11,-61,4,-60,-23v0,-17,15,-40,46,-37v-15,9,-22,19,-22,31v0,17,22,20,36,15r0,14xm33,0r0,-260r37,0r0,260r-37,0","w":103},"\u012f":{"d":"83,60v-22,11,-61,4,-60,-23v0,-17,15,-40,46,-37v-15,9,-22,19,-22,31v0,17,22,20,36,15r0,14xm35,0r0,-191r34,0r0,191r-34,0xm35,-226r0,-34r34,0r0,34r-34,0","w":104},"\u0132":{"d":"33,0r0,-260r37,0r0,260r-37,0xm71,16v43,15,75,5,75,-48r0,-228r37,0r0,227v2,69,-46,96,-112,81r0,-32","w":214},"\u0133":{"d":"35,0r0,-191r34,0r0,191r-34,0xm35,-226r0,-34r34,0r0,34r-34,0xm72,37v38,19,67,17,67,-37r0,-191r35,0r0,191v3,67,-49,88,-102,65r0,-28xm139,-226r0,-34r35,0r0,34r-35,0","w":208},"\u0134":{"d":"0,-282r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm-32,16v43,15,75,5,75,-48r0,-228r37,0r0,227v2,69,-46,96,-112,81r0,-32","w":111},"\u0135":{"d":"-27,37v38,19,67,17,67,-37r0,-191r35,0r0,191v3,67,-49,88,-102,65r0,-28xm-4,-226r42,-56r39,0r42,56r-26,0r-36,-35r-35,35r-26,0","w":109},"\u0136":{"d":"34,0r0,-260r34,0r0,128r105,-128r38,0r-102,124r120,136r-47,0r-114,-132r0,132r-34,0xm154,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":235},"\u0137":{"d":"35,0r0,-278r34,0r0,180r81,-93r37,0r-77,89r93,102r-44,0r-90,-98r0,98r-34,0xm144,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":210},"\u0138":{"d":"35,0r0,-191r34,0r0,93r81,-93r37,0r-77,89r93,102r-44,0r-90,-98r0,98r-34,0","w":210},"\u0139":{"d":"34,0r0,-260r36,0r0,232r118,0r0,28r-154,0xm30,-282r43,-56r40,0r-57,56r-26,0","w":191},"\u013a":{"d":"35,0r0,-278r34,0r0,278r-34,0xm26,-295r43,-56r40,0r-57,56r-26,0","w":104},"\u013b":{"d":"34,0r0,-260r36,0r0,232r118,0r0,28r-154,0xm143,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":191},"\u013c":{"d":"35,0r0,-278r34,0r0,278r-34,0xm86,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":104},"\u013d":{"d":"123,-180r0,-11v10,-1,13,-16,13,-35r-13,0r0,-34r34,0v2,39,-1,80,-34,80xm34,0r0,-260r36,0r0,232r118,0r0,28r-154,0","w":191},"\u013e":{"d":"104,-198r0,-10v10,-2,15,-16,14,-35r-14,0r0,-35r35,0v2,40,-2,80,-35,80xm35,0r0,-278r34,0r0,278r-34,0","w":104},"\u013f":{"d":"131,-113r0,-34r34,0r0,34r-34,0xm34,0r0,-260r36,0r0,232r118,0r0,28r-154,0","w":191},"\u0140":{"d":"104,-121r0,-35r35,0r0,35r-35,0xm35,0r0,-278r34,0r0,278r-34,0","w":104},"\u0143":{"d":"34,0r0,-260r36,0r131,201r0,-201r31,0r0,260r-36,0r-131,-201r0,201r-31,0xm107,-282r43,-56r40,0r-57,56r-26,0","w":265},"\u0144":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126xm82,-226r43,-56r40,0r-57,56r-26,0","w":223},"\u0145":{"d":"34,0r0,-260r36,0r131,201r0,-201r31,0r0,260r-36,0r-131,-201r0,201r-31,0xm162,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":265},"\u0146":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126xm151,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":223},"\u0147":{"d":"194,-338r-42,56r-38,0r-43,-56r26,0r36,35r35,-35r26,0xm34,0r0,-260r36,0r131,201r0,-201r31,0r0,260r-36,0r-131,-201r0,201r-31,0","w":265},"\u0148":{"d":"174,-282r-42,56r-39,0r-42,-56r26,0r36,36r35,-36r26,0xm156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"\u0149":{"d":"13,-198r0,-10v10,-2,15,-16,14,-35r-14,0r0,-35r35,0v2,40,-2,80,-35,80xm199,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,137r-35,0r0,-126","w":223},"\u014a":{"d":"150,43v27,12,57,3,51,-36r-136,-208r0,201r-31,0r0,-260r36,0r131,201r0,-201r31,0r0,276v2,46,-38,68,-82,54r0,-27","w":265},"\u014b":{"d":"156,-126v0,-25,-4,-38,-27,-39v-21,0,-41,13,-60,41r0,124r-34,0r0,-191r34,0r0,36v29,-56,122,-54,122,18r0,153v2,46,-39,68,-83,54r0,-27v26,12,48,2,48,-33r0,-136","w":223},"\u014c":{"d":"83,-282r0,-26r113,0r0,26r-113,0xm262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"\u014d":{"d":"54,-226r0,-26r113,0r0,26r-113,0xm202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"\u014e":{"d":"198,-334v0,47,-64,67,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,71,35,74,0r21,0xm262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"\u014f":{"d":"169,-278v-1,46,-64,68,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,70,35,73,0r22,0xm202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"\u0150":{"d":"99,-282r43,-56r33,0r-56,56r-20,0xm161,-282r42,-56r34,0r-56,56r-20,0xm262,-130v0,78,-47,137,-122,137v-76,0,-122,-59,-122,-137v0,-78,46,-137,122,-137v75,0,122,60,122,137xm57,-130v0,62,27,109,83,109v56,0,82,-47,82,-109v0,-63,-26,-109,-82,-109v-56,0,-83,47,-83,109","w":279},"\u0151":{"d":"70,-226r42,-56r34,0r-57,56r-19,0xm132,-226r42,-56r34,0r-57,56r-19,0xm202,-95v0,58,-33,99,-91,99v-58,0,-91,-40,-91,-99v0,-60,33,-100,91,-100v57,0,91,41,91,100xm56,-95v0,41,17,73,55,73v38,0,54,-32,54,-73v0,-42,-15,-74,-54,-74v-39,0,-55,33,-55,74","w":221},"\u0154":{"d":"190,-196v-1,38,-23,62,-53,74r87,122r-45,0r-74,-110r-35,0r0,110r-36,0r0,-260v73,-1,159,-10,156,64xm70,-138v47,2,80,-11,82,-54v2,-34,-38,-44,-82,-41r0,95xm83,-282r43,-56r40,0r-57,56r-26,0"},"\u0155":{"d":"35,0r0,-191r34,0r0,36v16,-30,37,-43,71,-39r0,32v-33,-10,-52,6,-71,36r0,126r-34,0xm57,-226r43,-56r40,0r-57,56r-26,0","w":147},"\u0156":{"d":"190,-196v-1,38,-23,62,-53,74r87,122r-45,0r-74,-110r-35,0r0,110r-36,0r0,-260v73,-1,159,-10,156,64xm70,-138v47,2,80,-11,82,-54v2,-34,-38,-44,-82,-41r0,95xm146,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28"},"\u0157":{"d":"35,0r0,-191r34,0r0,36v16,-30,37,-43,71,-39r0,32v-33,-10,-52,6,-71,36r0,126r-34,0xm93,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":147},"\u0158":{"d":"166,-338r-42,56r-39,0r-42,-56r26,0r36,35r35,-35r26,0xm190,-196v-1,38,-23,62,-53,74r87,122r-45,0r-74,-110r-35,0r0,110r-36,0r0,-260v73,-1,159,-10,156,64xm70,-138v47,2,80,-11,82,-54v2,-34,-38,-44,-82,-41r0,95"},"\u0159":{"d":"150,-282r-42,56r-39,0r-42,-56r26,0r36,36r35,-36r26,0xm35,0r0,-191r34,0r0,36v16,-30,37,-43,71,-39r0,32v-33,-10,-52,6,-71,36r0,126r-34,0","w":147},"\u015a":{"d":"163,-110v38,53,-10,117,-78,117v-18,0,-40,-4,-67,-12r0,-36v57,39,145,18,111,-48v-32,-34,-110,-48,-110,-109v0,-65,78,-83,141,-59r0,34v-49,-22,-96,-27,-106,20v2,33,36,41,61,57v22,14,40,24,48,36xm75,-282r43,-56r40,0r-57,56r-26,0","w":193},"\u015b":{"d":"144,-86v41,67,-42,113,-116,79r0,-31v23,11,42,16,59,16v18,0,34,-11,34,-28v0,-19,-30,-32,-48,-38v-68,-22,-52,-107,22,-107v12,0,33,2,47,6r0,29v-34,-11,-74,-19,-80,15v1,30,70,37,82,59xm61,-226r43,-56r40,0r-57,56r-26,0","w":183},"\u015c":{"d":"36,-282r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm163,-110v38,53,-10,117,-78,117v-18,0,-40,-4,-67,-12r0,-36v57,39,145,18,111,-48v-32,-34,-110,-48,-110,-109v0,-65,78,-83,141,-59r0,34v-49,-22,-96,-27,-106,20v2,33,36,41,61,57v22,14,40,24,48,36","w":193},"\u015d":{"d":"31,-226r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm144,-86v41,67,-42,113,-116,79r0,-31v23,11,42,16,59,16v18,0,34,-11,34,-28v0,-19,-30,-32,-48,-38v-68,-22,-52,-107,22,-107v12,0,33,2,47,6r0,29v-34,-11,-74,-19,-80,15v1,30,70,37,82,59","w":183},"\u0162":{"d":"95,0r0,-233r-92,0r0,-27r222,0r0,27r-93,0r0,233r-37,0xm150,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28"},"\u0163":{"d":"120,0v-46,14,-84,-7,-84,-53r0,-112r-24,0r0,-26r24,0r0,-35r35,-3r0,38r50,0r0,26r-50,0r0,106v-1,32,20,42,49,35r0,24xm123,47v-1,26,-34,35,-61,25r0,-14v11,5,36,6,36,-10v0,-11,-11,-17,-33,-17r17,-31r17,0r-10,19v16,-1,34,14,34,28","w":134},"\u0164":{"d":"175,-338r-42,56r-38,0r-43,-56r26,0r36,35r35,-35r26,0xm95,0r0,-233r-92,0r0,-27r222,0r0,27r-93,0r0,233r-37,0"},"\u0165":{"d":"101,-221r0,-11v10,-1,15,-15,14,-34r-14,0r0,-35r35,0v2,40,-2,80,-35,80xm120,0v-46,14,-84,-7,-84,-53r0,-112r-24,0r0,-26r24,0r0,-35r35,-3r0,38r50,0r0,26r-50,0r0,106v-1,32,20,42,49,35r0,24","w":207},"\u0166":{"d":"132,0r-37,0r0,-126r-53,0r0,-26r53,0r0,-81r-92,0r0,-27r222,0r0,27r-93,0r0,81r54,0r0,26r-54,0r0,126"},"\u0167":{"d":"120,0v-46,14,-84,-7,-84,-53r0,-47r-32,0r0,-21r32,0r0,-44r-24,0r0,-26r24,0r0,-35r35,-3r0,38r50,0r0,26r-50,0r0,44r50,0r0,21r-50,0v-3,44,-2,91,49,76r0,24","w":134},"\u0168":{"d":"66,-282v-2,-46,41,-47,67,-28v15,11,26,8,29,-13r21,0v2,46,-40,48,-66,28v-15,-11,-26,-8,-29,13r-22,0xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u0169":{"d":"52,-226v-2,-46,42,-47,67,-27v15,12,26,8,28,-14r22,0v2,46,-41,48,-67,28v-15,-11,-26,-9,-28,13r-22,0xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u016a":{"d":"71,-282r0,-26r113,0r0,26r-113,0xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u016b":{"d":"54,-226r0,-26r113,0r0,26r-113,0xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u016c":{"d":"186,-334v-1,47,-65,68,-99,38v-11,-9,-16,-22,-18,-38r21,0v3,34,71,35,74,0r22,0xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u016d":{"d":"169,-278v-1,46,-64,68,-98,38v-11,-9,-17,-22,-19,-38r22,0v3,34,70,35,73,0r22,0xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u016e":{"d":"165,-317v0,21,-19,39,-40,39v-21,0,-40,-18,-40,-39v0,-21,18,-40,40,-40v22,0,40,19,40,40xm100,-317v0,13,12,24,25,24v13,0,25,-12,25,-24v0,-13,-11,-25,-25,-25v-14,0,-25,11,-25,25xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u016f":{"d":"150,-265v0,21,-18,39,-39,39v-22,0,-40,-17,-40,-39v0,-22,18,-40,40,-40v22,0,39,18,39,40xm86,-265v0,13,12,24,25,24v13,0,24,-11,24,-24v0,-13,-11,-25,-24,-25v-14,0,-25,11,-25,25xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u0170":{"d":"86,-282r43,-56r33,0r-56,56r-20,0xm148,-282r43,-56r33,0r-56,56r-20,0xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u0171":{"d":"67,-226r43,-56r33,0r-56,56r-20,0xm129,-226r42,-56r34,0r-56,56r-20,0xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u0172":{"d":"178,60v-22,11,-60,4,-60,-23v0,-17,16,-41,47,-37v-15,9,-23,19,-23,31v0,17,22,20,36,15r0,14xm127,7v-67,2,-96,-35,-96,-103r0,-164r37,0r0,164v0,48,16,75,61,75v46,0,57,-24,57,-74r0,-165r32,0r0,165v2,69,-28,100,-91,102","w":249},"\u0173":{"d":"186,60v-22,11,-60,4,-60,-23v0,-17,16,-41,47,-37v-15,9,-23,19,-23,31v0,17,22,20,36,15r0,14xm67,-65v0,26,5,40,27,40v21,0,41,-14,60,-42r0,-124r35,0r0,191r-35,0r0,-36v-29,56,-121,56,-121,-18r0,-137r34,0r0,126","w":223},"\u0174":{"d":"94,-282r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm67,0r-67,-260r36,0r53,205r49,-205r36,0r46,203r57,-203r30,0r-73,260r-36,0r-46,-201r-48,201r-37,0","w":307},"\u0175":{"d":"79,-226r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm57,0r-55,-191r34,0r42,148r45,-148r35,0r39,148r48,-148r30,0r-62,191r-35,0r-41,-148r-45,148r-35,0","w":277},"\u0176":{"d":"54,-282r42,-56r38,0r43,56r-26,0r-36,-35r-35,35r-26,0xm90,0r0,-109r-87,-151r42,0r68,117r72,-117r35,0r-93,151r0,109r-37,0","w":224},"\u0177":{"d":"35,-226r43,-56r38,0r42,56r-26,0r-35,-35r-36,35r-26,0xm46,69r31,-69r-74,-191r37,0r55,144r58,-144r33,0r-104,260r-36,0","w":188},"\u0179":{"d":"17,0r0,-30r139,-203r-131,0r0,-27r176,0r0,27r-140,203r140,0r0,30r-184,0xm84,-282r43,-56r40,0r-57,56r-26,0","w":217},"\u017a":{"d":"22,0r0,-26r118,-139r-113,0r0,-26r155,0r0,26r-118,139r121,0r0,26r-163,0xm72,-226r43,-56r40,0r-57,56r-26,0","w":206},"\u017b":{"d":"96,-282r0,-35r34,0r0,35r-34,0xm17,0r0,-30r139,-203r-131,0r0,-27r176,0r0,27r-140,203r140,0r0,30r-184,0","w":217},"\u017c":{"d":"86,-226r0,-34r34,0r0,34r-34,0xm22,0r0,-26r118,-139r-113,0r0,-26r155,0r0,26r-118,139r121,0r0,26r-163,0","w":206},"\u2032":{"d":"26,-173r35,-105r39,0r-52,105r-22,0","w":117},"\u2033":{"d":"26,-173r35,-105r39,0r-52,105r-22,0xm104,-173r35,-105r39,0r-52,105r-22,0","w":195},"\u017f":{"d":"143,-249v-37,-11,-67,-15,-67,32r0,217r-35,0r0,-165r-27,0r0,-26r27,0v-9,-73,35,-107,102,-85r0,27","w":125},"\u00a4":{"d":"67,-68r-34,34r-16,-15r35,-34v-22,-27,-21,-67,0,-94r-35,-34r16,-16r34,35v29,-21,65,-21,94,0r34,-35r15,16r-34,34v21,27,21,67,0,94r34,34r-15,15r-34,-34v-29,22,-65,21,-94,0xm62,-130v0,29,23,52,52,52v29,0,52,-23,52,-52v0,-29,-23,-52,-52,-52v-29,0,-52,23,-52,52"}}});
