<?php
/**
/**
 * Plugin Name: Mini Gallery
 * Version: 1.1
 * Author: CreativeWorkz
 * Author URI: http://creativeworkz.co.uk
 *
 */

add_action( 'widgets_init', 'load_mini_gallery' );

/**
 * Register our widget.
 * 'Mini_Gallery_Widget' is the widget class used below.
 *
 * @since 0.1
 */
function load_mini_gallery() {
	register_widget( 'Mini_Gallery_Widget' );
}

/**
 * Example Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 0.1
 */
class Mini_Gallery_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function Mini_Gallery_Widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'gallery', 'description' => __('DynamiX Widget Image/Text gallery, use posts or a gallery slide set.', 'gallery') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'gallery-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'gallery-widget', __('DynamiX Widget Gallery', 'gallery'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$height = $instance['height'];
		$img_effect = $instance['img_effect'];
		$content_type = $instance['content_type'];
		$cats = $instance['gallerycats'];
		$slidesetid = $instance['slidesetid'];
		$id = $instance['id'];
		$timeout = $instance['timeout'];
		
		

		/* Before widget (defined by themes). */
		echo "<li class=\"widget sidebar-slider\">";
		
		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Display categories from widget settings if one was input. */
		if ( $cats || $slidesetid )

        if($height) { // Calculate gallery height based on effect
        $DYN_galleryheight = $height+"35";
        } else {
		$DYN_galleryheight = "175";
		}
		
		$chars = array("[", "]");
		$galid = str_replace($chars,"",$this->get_field_name( 'id' ));
		?>        
<div class="mini-slider <?php echo $galid; ?>" style="height:<?php echo $DYN_galleryheight; ?>px">
		
		<?php

		if(!$slidesetid) {
		
		
		$postcount = 0;	
		foreach ($cats as $value)
		{
		$string = $string.$value.",";
    	}
		
		$string = lTrim($string,',');
			
			
			$args=array(
			  'post_type' => 'post',
			  'post_status' => 'publish',
			  'meta_key' => 'Order',
			  'cat' => $string,
			  'orderby' => 'meta_value',
			  'order' => 'ASC',
			  'posts_per_page' => -1,
			  'caller_get_posts'=> 1
			);
			
			$featured_query = new wp_query($args);  
			

while ($featured_query->have_posts()) : $featured_query->the_post(); 

/******************  Get custom field data ******************/             

$pdata = maybe_unserialize(get_post_meta( get_the_ID(), 'pgopts', true ));

$DYN_movieurl = $pdata["movieurl"]; // Movie File URL
$DYN_previewimgurl=$pdata["previewimgurl"]; // Preview Image URL
$DYN_disablegallink=$pdata["disablegallink"];
$DYN_galexturl=$pdata["galexturl"];
$DYN_imgzoomcrop=$pdata["imgzoomcrop"];
if(!$instance['excerpt']) {
	$DYN_galleryexcerpt="55";
} else {
	$DYN_galleryexcerpt=$instance['excerpt'];
}
/****************** / Get custom field data *****************/ 

$do_not_duplicate[] = get_the_ID();

$postcount++;

$image = catch_image(); // Check for images within post


?>


<?php if($content_type!="text") { ?>
<div class="panel <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="shadowreflection") { ?>reflectshadow<?php } ?>" >
    
	<div class="panel-inner">
        
	<?php if($DYN_previewimgurl) { // Check "Preview Image" field is completed ?>     
   
		<div class="container  <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="reflection") { ?>reflection<?php } elseif($img_effect=="shadowreflection") { ?>shadowreflection<?php } ?>">
			<div class="gridimg-wrap">
				<?php if(!$DYN_disablegallink) { ?>
					<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink(get_the_ID()); } ?>"><?php } ?>
						<img <?php if($img_effect=="reflection" || $img_effect=="shadowreflection") { ?>class="reflect"<?php } ?> src="<?php bloginfo('template_directory'); ?>/lib/scripts/timthumb.php?src=<?php echo dyn_getimagepath($DYN_previewimgurl); ?>&amp;h=<?php if($height) { echo $height; } else { ?>145<?php } ?>&amp;w=220&amp;zc=<?php if($DYN_imgzoomcrop!="zoom") {?>0<?php } else {?>1<?php } ?>" alt="<?php the_title(); ?>" width="220" height="<?php if($height) { echo $height; } else { ?>145<?php } ?>" />
				<?php if(!$DYN_disablegallink) { ?>
					</a>
				<?php } ?>
            	
			</div><!-- / gridimg-wrap -->
		</div><!-- / container -->				
				
	<?php } elseif($image) { // Check image exists within post ?>
            	
		<div class="container  <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="reflection") { ?>reflection<?php } elseif($img_effect=="shadowreflection") { ?>shadowreflection<?php } ?>">
			<div class="gridimg-wrap">
                   
				<?php if(!$DYN_disablegallink) { ?>
					<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink($post->ID); } ?>"><?php } ?>
						<img <?php if($img_effect=="reflection" || $img_effect=="shadowreflection") { ?>class="reflect"<?php } ?> src="<?php bloginfo('template_directory'); ?>/lib/scripts/timthumb.php?src=<?php echo dyn_getimagepath($image); ?>&amp;h=<?php if($height) { echo $height; } else { ?>145<?php } ?>&amp;w=220&amp;zc=<?php if($DYN_imgzoomcrop!="zoom") {?>0<?php } else {?>1<?php } ?>" alt="<?php the_title(); ?>" width="220" height="<?php if($height) { echo $height; } else { ?>145<?php } ?>" />
				<?php if(!$DYN_disablegallink) { ?>
					</a>
				<?php } ?>
                
            </div><!-- / gridimg-wrap --> 
        </div><!-- / shadow -->		         
	<?php } ?>            
     </div><!--  / panel-inner -->
</div><!--  / panel -->          
<?php } else { ?>

<div class="panel text">
    
	<div class="panel-inner">
        
		<div class="panelcontent">
			<h5><?php if(!$DYN_disablegallink) { ?><a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink($post->ID); } ?>" title="<?php echo the_title(); ?>"><?php } ?><?php echo the_title(); ?><?php if(!$DYN_disablegallink) { ?></a><?php } ?></h5>
			
			<?php global $more; $more = FALSE; ?>
			<?php if ( empty($post->post_excerpt) ) {
    					
				the_excerpt_reloaded($DYN_galleryexcerpt, '<a>', 'content', false);
				if(!$DYN_disablegallink) { ?>
				<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink($post->ID); } ?>"><?php echo GEN_TERM_A; ?></a>
				<?php }
			} else {
						
				the_excerpt(); 
				if(!$DYN_disablegallink) { ?>
				<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink($post->ID); } ?>"><?php echo GEN_TERM_A; ?></a>
				<?php }
    					
			} ?>
       		
		</div><!-- /panelcontent --> 
          
    </div><!--  / panel-inner -->
</div><!--  / panel -->  
 
<?php } ?>
<?php endwhile;

wp_reset_query();

} else { // use slide set

$postcount=0;

$get_slideset_num = get_option('slideset_number');
$get_slideset_data = get_option('slideset_data');

$gallery_count = $get_slideset_num;
                
for($i = 0; $i < $gallery_count; $i++) { // Find Slide Set ID Number from Slide Set ID Name	
	if($slidesetid==$get_slideset_data['slideset_id'.$i.'_id']) {
		$slideset_id = $i;
	}
}


$get_slides_count = $get_slideset_data['slideset_id'.$slideset_id.'_slide_count'];


$z = 0;
while ($z < $get_slides_count):

/******************  Get custom field data ******************/             

$DYN_movieurl = $get_slideset_data['slideset_id'.$slideset_id.'_videourl_'.$z]; // Movie File URL
$DYN_previewimgurl=$get_slideset_data['slideset_id'.$slideset_id.'_url_'.$z]; // Preview Image URL
if(!$get_slideset_data['slideset_id'.$slideset_id.'_link_'.$z]) {
$DYN_disablegallink="yes";
} 
$DYN_galexturl=$get_slideset_data['slideset_id'.$slideset_id.'_link_'.$z];
$DYN_imgzoomcrop=strtolower($get_slideset_data['slideset_id'.$slideset_id.'_crop_'.$z]);
$DYN_description=stripslashes($get_slideset_data['slideset_id'.$slideset_id.'_desc_'.$z]);
$DYN_posttitle=stripslashes($get_slideset_data['slideset_id'.$slideset_id.'_title_'.$z]);

/****************** / Get custom field data *****************/ 
?>

<?php if($content_type!="text") { ?>
<div class="panel <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="shadowreflection") { ?>reflectshadow<?php } ?>">
    
	<div class="panel-inner">
        
	<?php if($DYN_previewimgurl) { // Check "Preview Image" field is completed ?>     
   
		<div class="container  <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="reflection") { ?>reflection<?php } elseif($img_effect=="shadowreflection") { ?>shadowreflection<?php } ?>">
			<div class="gridimg-wrap">
				<?php if(!$DYN_disablegallink) { ?>
					<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink(get_the_ID()); } ?>"><?php } ?>
						<img <?php if($img_effect=="reflection" || $img_effect=="shadowreflection") { ?>class="reflect"<?php } ?> src="<?php bloginfo('template_directory'); ?>/lib/scripts/timthumb.php?src=<?php echo dyn_getimagepath($DYN_previewimgurl); ?>&amp;h=<?php if($height) { echo $height; } else { ?>145<?php } ?>&amp;w=220&amp;zc=<?php if($DYN_imgzoomcrop!="zoom") {?>0<?php } else {?>1<?php } ?>" alt="<?php the_title(); ?>" width="220" height="<?php if($height) { echo $height; } else { ?>145<?php } ?>" />
				<?php if(!$DYN_disablegallink) { ?>
					</a>
				<?php } ?>
            	
			</div><!-- / gridimg-wrap -->
		</div><!-- / container -->				
				
	<?php } elseif($image) { // Check image exists within post ?>
            	
		<div class="container  <?php if($img_effect=="shadow") { ?>shadow<?php } elseif($img_effect=="reflection") { ?>reflection<?php } elseif($img_effect=="shadowreflection") { ?>shadowreflection<?php } ?>">
			<div class="gridimg-wrap">
                   
				<?php if(!$DYN_disablegallink) { ?>
					<a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } else { echo get_permalink($post->ID); } ?>"><?php } ?>
						<img <?php if($img_effect=="reflection" || $img_effect=="shadowreflection") { ?>class="reflect"<?php } ?> src="<?php bloginfo('template_directory'); ?>/lib/scripts/timthumb.php?src=<?php echo dyn_getimagepath($image); ?>&amp;h=<?php if($height) { echo $height; } else { ?>145<?php } ?>&amp;w=220&amp;zc=<?php if($DYN_imgzoomcrop!="zoom") {?>0<?php } else {?>1<?php } ?>" alt="<?php the_title(); ?>" width="220" height="<?php if($height) { echo $height; } else { ?>145<?php } ?>" />
				<?php if(!$DYN_disablegallink) { ?>
					</a>
				<?php } ?>
                
            </div><!-- / gridimg-wrap --> 
        </div><!-- / shadow -->		         
	<?php } ?>            
     </div><!--  / panel-inner -->
</div><!--  / panel -->          
<?php } else { ?>

<div class="panel text">
    
	<div class="panel-inner">
        
		<div class="panelcontent">
        	<?php if($DYN_posttitle) { ?>
			<h5><?php if(!$DYN_disablegallink) { ?><a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } ?>" title="<?php echo $DYN_posttitle; ?>"><?php } ?><?php echo $DYN_posttitle; ?><?php if(!$DYN_disablegallink) { ?></a><?php } ?></h5>
			<?php } ?>

            
			<?php echo do_shortcode($DYN_description);
			
			if(!$DYN_disablegallink) { ?>
			<p><a href="<?php if($DYN_galexturl) { echo $DYN_galexturl; } ?>"><?php echo GEN_TERM_A; ?></a></p>
			<?php } ?>
			

       		
		</div><!-- /panelcontent --> 
          
    </div><!--  / panel-inner -->
</div><!--  / panel -->   

<?php } ?>        

<?php $z++; endwhile;

}

$postcount = 0; 


		/* Define default settings */
		if($instance['tween_type']) {
			$DYN_tween=$instance['tween_type'];
		} else {
			$DYN_tween="easeInOutExpo";
		}
		
		if($instance['tween_type']) {
			$DYN_animation=$instance['animation_type'];
		} else {
			$DYN_animation="scrollHorz";
		}
		
		if($instance['timeout']) {
			$DYN_timeout=$instance['timeout']*1000;
		} else {
			$DYN_timeout=$instance['timeout']="5000";
		}
				
?>
</div><!-- / mini-slider -->
<script type='text/javascript'>
<!--
jQuery(window).load(function() {

	jQuery('.mini-slider.<?php echo $galid; ?>').cycle({ 
		fx:     '<?php echo $DYN_animation; ?>', 
		timeout: <?php echo $DYN_timeout; ?>,
		speed: 750,
		easing: '<?php echo $DYN_tween; ?>',		
		prev: '#leftnav',
		next: '#rightnav',
		cleartype:  true,
    	cleartypeNoBg:  true
	});



});
//-->
</script>

		<?php	echo "</li>";
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['height'] = strip_tags( $new_instance['height'] );
		
		$instance['gallerycats'] = $new_instance['gallerycats'];
		$instance['slidesetid'] = $new_instance['slidesetid'];
		$instance['img_effect'] = $new_instance['img_effect'];
		$instance['content_type'] = $new_instance['content_type'];
		$instance['tween_type'] = $new_instance['tween_type'];
		$instance['animation_type'] = $new_instance['animation_type'];
		$instance['timeout'] = $new_instance['timeout'];
		$instance['excerpt'] = $new_instance['excerpt'];

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */ ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title: (Optional)', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:96%;" />
		</p>

		<!-- Image Height: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'height' ); ?>"><?php _e('Image Height:', 'gallery'); ?></label><br />
			<input id="<?php echo $this->get_field_id( 'height' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $instance['height']; ?>" style="width:50%;" /><small> px <em>( Default is 145 )</em></small>	
		</p>

		<p>
		<small class="description">Please select either a Gallery Slide Set or Post Category.</small>
        <h4>Slide Set ID</h4>
		<p><small class="description">Selecting a Slide Set ID will override any category selected.</small></p>
        <select id="<?php echo $this->get_field_id( 'slidesetid' ); ?>" name="<?php echo $this->get_field_name( 'slidesetid' ); ?>">
					<?php 
                    $get_slideset_num = get_option('slideset_number');
                    $get_slideset_data = get_option('slideset_data');
                    
                    if(!$get_slideset_num) {?>
                            <option value="">No Slide Sets</option>            	
                    <?php } else { ?>
                    		<option value="">Disabled</option>
                            <?php
                        	
                            $gallery_count = $get_slideset_num;
                
                            for($i = 0; $i < $gallery_count; $i++) {
                            if($instance['slidesetid']==$get_slideset_data['slideset_id'.$i.'_id']) {
                            $option = '<option selected="selected" value="'.$get_slideset_data['slideset_id'.$i.'_id'].'">';
                            } else {
                            $option = '<option value="'.$get_slideset_data['slideset_id'.$i.'_id'].'">';
                            }
                            $option .= $get_slideset_data['slideset_id'.$i.'_id'];
                            $option .= '</option>';
                            echo $option;        
                            
                            }
                        
                    }
                    ?>
		</select>    
        </p>
		<p>
        <h4>Categories</h4>

		<p>
			<label for="<?php echo $this->get_field_id( 'excerpt' ); ?>"><?php _e('Excerpt:', 'gallery'); ?></label><br />
			<input id="<?php echo $this->get_field_id( 'excerpt' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'excerpt' ); ?>" value="<?php echo $instance['excerpt']; ?>" style="width:50px" /><small class="description"><em>( Default is 55 words )</em></small>	
		</p>
        
        
        <label for="<?php echo $this->get_field_id( 'gallerycats' ); ?>"><?php _e('Select Post Categories:', 'Categories'); ?></label><br /><br />
			<?php 
				$categories=  get_categories(); 
				foreach ($categories as $cat) {
					$option='<input type="checkbox" id="'. $this->get_field_id( 'gallerycats' ) .'[]" name="'. $this->get_field_name( 'gallerycats' ) .'[]"';
					if (is_array($instance['gallerycats'])) {
					foreach ($instance['gallerycats'] as $cats) {					
					if($cats==$cat->term_id) {
					$option=$option.' checked="checked"'; 
					}
					}
					}
					$option .= ' value="'.$cat->term_id.'" />';

                    $option .= $cat->cat_name;
                    $option .= ' ('.$cat->category_count.')';
                    $option .= '<br />';
                    echo $option;
                  }
				  
			?>		

		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'timeout' ); ?>"><?php _e('Timeout:', 'gallery'); ?></label><br />
			<input id="<?php echo $this->get_field_id( 'timeout' ); ?>" class="widefat" name="<?php echo $this->get_field_name( 'timeout' ); ?>" value="<?php echo $instance['timeout']; ?>" style="width:50px" /><small> seconds <em>( Default is 5 )</em></small>	
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'content_type' ); ?>"><?php _e('Content Type:', 'gallery'); ?></label> 
			<select id="<?php echo $this->get_field_id( 'content_type' ); ?>" name="<?php echo $this->get_field_name( 'content_type' ); ?>" class="widefat" style="width:100%;">
				<option value="" <?php if ( '' == $instance['content_type'] ) echo 'selected="selected"'; ?>>Image</option>
                <option value="text" <?php if ( 'text' == $instance['content_type'] ) echo 'selected="selected"'; ?>>Text</option>
			</select>
		</p>

		<!-- Image Effect: Select Box -->
		<p>
			<label for="<?php echo $this->get_field_id( 'img_effect' ); ?>"><?php _e('Image Effect:', 'gallery'); ?></label> 
			<select id="<?php echo $this->get_field_id( 'img_effect' ); ?>" name="<?php echo $this->get_field_name( 'img_effect' ); ?>" class="widefat" style="width:100%;">
				<option value="none" <?php if ( 'none' == $instance['img_effect'] ) echo 'selected="selected"'; ?>>No Effect</option>
                <option value="shadow" <?php if ( 'shadow' == $instance['img_effect'] ) echo 'selected="selected"'; ?>>Shadow</option>
				<option value="reflection" <?php if ( 'reflection' == $instance['img_effect'] ) echo 'selected="selected"'; ?>>Reflection</option>
                <option value="shadowreflection" <?php if ( 'shadowreflection' == $instance['img_effect'] ) echo 'selected="selected"'; ?>>Reflection &amp; Shadow</option>
			</select>
		</p>


        <p>
        <label for="<?php echo $this->get_field_id( 'animation_type' ); ?>"><?php _e('Animation Type:', 'gallery'); ?></label> 
        <select id="<?php echo $this->get_field_id( 'animation_type' ); ?>" name="<?php echo $this->get_field_name( 'animation_type' ); ?>" class="widefat" style="width:100%;">
        <?php 
				 $animation_types = array("blindX","blindY","blindZ","cover","curtainX","curtainY","fade","fadeZoom","growX","growY","none","scrollUp","scrollDown","scrollLeft","scrollRight","scrollHorz","scrollVert","shuffle","slideX","slideY","toss","turnUp","turnDown","turnLeft","turnRight","uncover","wipe","zoom");
		 
                  foreach ($animation_types as $animation_type) {
				  	if($instance['animation_type']==$animation_type) {
                    $option = '<option selected="selected" value="'.$animation_type.'">';
					} else {
					$option = '<option value="'.$animation_type.'">';
					}
                    $option .= $animation_type;
                    $option .= '</option>';
                    echo $option;
                  } ?>
					

        </select>    
        </p>
        
        <p>
        <label for="<?php echo $this->get_field_id( 'tween_type' ); ?>"><?php _e('Tween Type:', 'gallery'); ?></label> 
        <select id="<?php echo $this->get_field_id( 'tween_type' ); ?>" name="<?php echo $this->get_field_name( 'tween_type' ); ?>" class="widefat" style="width:100%;">
        <?php 
				 $tween_types = array("linear","easeInSine","easeOutSine", "easeInOutSine", "easeInCubic", "easeOutCubic", "easeInOutCubic", "easeInQuint", "easeOutQuint", "easeInOutQuint", "easeInCirc", "easeOutCirc", "easeInOutCirc", "easeInBack", "easeOutBack", "easeInOutBack", "easeInQuad", "easeOutQuad", "easeInOutQuad", "easeInQuart", "easeOutQuart", "easeInOutQuart", "easeInExpo", "easeOutExpo", "easeInOutExpo", "easeInElastic", "easeOutElastic", "easeInOutElastic", "easeInBounce", "easeOutBounce", "easeInOutBounce");
		 
                  foreach ($tween_types as $tween_type) {
				  	if($instance['tween_type']==$tween_type) {
                    $option = '<option selected="selected" value="'.$tween_type.'">';
					} else {
					$option = '<option value="'.$tween_type.'">';
					}
                    $option .= $tween_type;
                    $option .= '</option>';
                    echo $option;
                  } ?>
					

        </select>    
        </p>

	<?php
	}
}

?>
