<?php 
//If the form is submitted
if(isset($_POST['submitted'])) {

	//Check to see if the honeypot captcha field was filled in
	if(trim($_POST['checking']) !== '') {
		$captchaError = true;
	} else {
	
		//Check to make sure that the name field is not empty
		if(trim($_POST['name']) === '') {
			$nameError = 'You forgot to enter your name.';
			$hasError = true;
		} else {
			$name = trim($_POST['name']);
		}
		
		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['email']) === '')  {
			$emailError = 'You forgot to enter your email address.';
			$hasError = true;
		} else if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,4}$", trim($_POST['email']))) {
			$emailError = 'You entered an invalid email address.';
			$hasError = true;
		} else {
			$email = trim($_POST['email']);
		}
			
		//Check to make sure comments were entered	
		if(trim($_POST['comments']) === '') {
			$commentError = 'You forgot to enter your comments.';
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = trim($_POST['comments']);
			}
		}
			
		//If there is no error, send the email
		if(!isset($hasError)) {
			
			if(get_option("contactemail")) { 
			$emailTo = get_option("contactemail");
			} else {
			$emailTo = get_option("admin_email");
			}
			$subject = 'Contact Form Submission from '.$name;
			$sendCopy = trim($_POST['sendCopy']);
			$body = "Name: $name \n\nEmail: $email \n\nComments: $comments";
			$headers = 'From: My Site <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;
			
			mail($emailTo, $subject, $body, $headers);

			if($sendCopy == true) {
				$subject = 'You emailed Your Name';
				$headers = 'From: Your Name <noreply@somedomain.com>';
				mail($email, $subject, $body, $headers);
			}

			$emailSent = true;

		}
	}
} ?>



<?php if(isset($emailSent) && $emailSent == true) { ?>

	<div class="thanks">
		<h1>Thanks, <?php $name;?></h1>
		<p>Your email was successfully sent. I will be in touch soon.</p>
	</div>

<?php } else { ?>

		<form action="<?php the_permalink(); ?>" id="contactform" method="post">
			
            <ol class="forms">
            <?php if(isset($hasError) || isset($captchaError)) { ?>
            <li>
            	<span><img src="<?php bloginfo('template_url') ?>/images/error.png" alt="error key" /> = Required fields not completed</span><div class="clear"></div>
            </span>
			<?php } elseif(get_option("contactdesc")) { ?>
            <li>
            <?php echo get_option("contactdesc"); ?>
            </li>
            <?php } ?>
			<li>
                <div class="input-wrap" <?php if($nameError != '') { ?> style="background:#FFC1C1" onclick="this.style.background='#ffffff'" <?php } ?>><div><input type="text" class="field" name="name" id="name" value="<?php if(isset($_POST['name'])) echo $_POST['name'];?>" /></div></div>
                <label for="name"><small> Name</small></label>
			</li>
            
			<li>
                   <div class="input-wrap" <?php if($emailError != '') { ?> style="background:#FFC1C1" onclick="this.style.background='#ffffff'" <?php } ?> ><div><input type="text" class="field" name="email" id="email" value="<?php if(isset($_POST['email']))  echo $_POST['email'];?>" /></div></div>					                   <label for="email"><small> Email</small></label>
			</li>
				
			<li class="textarea">
                    <div class="input-wrap" <?php if($commentError != '') { ?> style="background:#FFC1C1" onclick="this.style.background='#ffffff'" <?php } ?>><div><textarea class="field" class="field" name="comments" id="commentsText" rows="20" cols="30" ><?php if(isset($_POST['comments'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST['comments']); } else { echo $_POST['comments']; } } ?></textarea></div></div>
                    <label class="screenReader" for="commentsText">Enquiry</label>
			</li>
			<li class="screenReader"><label for="checking" class="screenReader">If you want to submit this form, do not enter anything in this field</label><input type="text" name="checking" id="checking" class="screenReader" value="<?php if(isset($_POST['checking']))  echo $_POST['checking'];?>" /></li>
				<li class="buttons"><input type="hidden" name="submitted" id="submitted" value="true" />
                <div class="clear"></div>
                <button type="submit">Submit</button></li>
			</ol>
            
        </form>
 
<?php } ?>	
